<?php

// Get a list of all available languages
function get_language_name($abbr)
{
    $languages = array('en_US' => _('English') . ' (English)',
                       'de_DE' => _('German') . ' (Deutsche)',
                       'es_ES' => _('Spanish') . ' (español)',
                       'bg_BG' => _('Bulgarian') . ' (българин)',
                       'cs_CZ' => _('Czech') . ' (čeština)',
                       'fr_FR' => _('French') . ' (français)',
                       'it_IT' => _('Italian') . ' (italiano)',
                       'ja_JP' => _('Japanese') . ' (日本語)',
                       'ko_KR' => _('Korean') . ' (한국어)',
                       'pl_PL' => _('Polish') . ' (polski)',
                       'pt_PT' => _('Portuguese') . ' (português)',
                       'ru_RU' => _('Russian') . ' (русский)',
                       'zh_CN' => _('Chinese (Simplified)') . ' (中文-简化字)',
                       'zh_TW' => _('Chinese (Traditional)') . ' (中文-繁體字)');
    return $languages[$abbr];
}

// Get all languages as an array
function get_languages()
{
    $languages = array();
    $path = APPPATH."language";
    $results = scandir($path);
    foreach ($results as $r) {
        if ($r === '.' || $r === '..' || $r === '.svn' || strpos($r,'_') != true) { continue; }
        if (is_dir($path . '/' . $r)) {
            if ($r == "en_US") {
                array_unshift($languages, $r);
            } else {
                $languages[] = $r;
            }
        }
    }

    return $languages;
}

function set_language($language)
{
    // Fix for wrong en_US language name (en and en_EN)
    if (empty($language)) {
        $language = 'en_US';
    }

    // Only set gettext (now _()) locale if we have a language file
    if (!file_exists(dirname(__FILE__) . '/../language/' . $language)) {
        return;
    }

    // Set the locale/environment language
    setlocale(LC_MESSAGES, $language, $language . '.utf-8', 'en_US', 'en_US.utf-8');
    putenv("LANG=" . $language);

    // Non-English numeric formats will turn decimals to commas and mess up all kinds of stuff
    // so we aren't going to do that
    setlocale(LC_NUMERIC, 'C');

    // Bind text domains
    bindtextdomain($language, dirname(__FILE__) . '/../language/');
    bind_textdomain_codeset($language, 'UTF-8');
    textdomain($language);
}
