<?php echo $header; ?>

<script type="text/javascript">
$(document).ready(function() {

    if (window.location.hash == "#manual") {
        $('form').attr("action", "<?php echo site_url('admin/activate'); ?>#manual");
        $('#auto').hide();
        $('#manual').show();
    }

    $('#use-manual').click(function() {
        $('form').attr("action", "<?php echo site_url('admin/activate'); ?>#manual");
        $('#auto').hide();
        $('#manual').show();
        window.location.hash = "#manual";
    });

});
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <h1 class="form-title"><?php echo _('Product Activation'); ?></h1>
        <?php if (is_license_activated()) { ?>
        <p class="form-subtitle">
            <?php echo _("No action required. Your license has already been activated."); ?>
        </p>
        <?php exit(); } ?>

        <?php if (!empty($error)) { ?><div class="alert alert-danger"><?php echo $error; ?></div><?php } ?>

        <p class="form-subtitle">
            <?php echo _('Activate your license from inside Log Server by entering your client ID or token here.'); ?>
            <br><?php echo _('If you are offline or having trouble with automatic activation, you can'); ?> <a id="use-manual"><?php echo _('manually activate your license'); ?></a>.
        </p>
        <div class="form-spacer"></div>

        <?php echo form_open('admin/activate', array("class" => "form-horizontal")); ?>
        <div id="auto" class="tw-flex tw-flex-col tw-gap-2 tw-w-1/2">
            <div class="tw-mb-4">
                <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="client_id"><?php echo _('Client ID / Token'); ?></label>
                <div class="tw-flex tw-items-center tw-gap-2">
                    <input type="text" id="client_id" name="client_id" class="ui-input">
                    &nbsp;
                    <?php echo question_tooltip(_('Your client ID or token should be in the license email. Contact sales@nagios.com if you do not know yours.')); ?>
                </div>
            </div>
            <div class="tw-mb-4">
                <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="license_key"><?php echo _('License Key'); ?></label>
                <input type="text" id="license_key" name="license_key" value="<?php echo get_license_key(); ?>" disabled class="ui-input">
            </div>
            <div class="tw-mb-4">
                <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="server_ip"><?php echo _('Server IP'); ?></label>
                <input type="text" id="server_ip" name="server_ip" value="<?php echo $_SERVER['SERVER_ADDR']; ?>" disabled class="ui-input">
            </div>
        </div>
        <div id="manual" class="hide">
            <div class="tw-mb-4">
                <div class="form-subheader tw-flex tw-items-center tw-gap-2">
                    <?php echo _('Using the server IP below, fill out the'); ?> <a class="badge tw-w-fit" href="https://www.nagios.com/activate/" target="_new">activation form<i class="material-symbols-outlined small">arrow_forward</i></a> <?php echo _('to get an activation key and enter it below.'); ?>
                </div>
            </div>
            <div class="tw-flex tw-flex-col tw-gap-2 tw-w-1/2">
                <div class="tw-mb-4">
                    <label class="tw-block tw-text-sm tw-font-medium tw-mb-1"><?php echo _('License Key'); ?></label>
                    <input type="text" readonly value="<?php echo get_license_key(); ?>" class="ui-input">
                </div>
                <div class="tw-mb-4">
                    <label class="tw-block tw-text-sm tw-font-medium tw-mb-1"><?php echo _('Server IP'); ?></label>
                    <input type="text" readonly value="<?php echo $_SERVER['SERVER_ADDR']; ?>" class="ui-input">
                </div>
                <div class="tw-mb-4">
                    <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="activation_key"><?php echo _('Activation Key'); ?></label>
                    <input type="text" id="activation_key" name="activation_key" class="ui-input">
                </div>
            </div>
        </div>
        <div class="tw-mt-4">
            <div class="tw-flex tw-gap-2">
                <button type="submit" class="ui-btn ui-btn-default"><?php echo _('Activate'); ?></button>
                <a href="<?php echo site_url('admin/license'); ?>" class="ui-btn ui-btn-outlined"><?php echo _('Cancel'); ?></a>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>

<?php echo $footer; ?>