<?php echo $header; 

$ci =& get_instance();
$ci->load->helper('auditlog');

foreach ($logs as $index => $log) {
    if (isset($log['_source']['actions']) && json_decode($log['_source']['actions']) !== null) {
        $logs[$index]['_source']['actions'] = rerun_query_link(json_decode($log['_source']['actions'], true));
    }
}
?>

<script type="text/javascript">
$(document).ready(function() {

    update_datetimepicker();
    $('input.date-picker').datetimepicker({
        showOtherMonths: true,
        selectOtherMonths: true
    });

    $('select[name="time"]').change(function() {
        update_datetimepicker();
    });

    $('div.show-arguments-link').click(function() {
        $(this).css('display', 'none');
        $(this).siblings('div.hide-arguments-link').css('display', 'inline');
        $(this).siblings('div.arguments-data').show();
    });

    $('div.hide-arguments-link').click(function() {
        $(this).siblings('div.show-arguments-link').css('display', 'inline');
        $(this).css('display', 'none');
        $(this).siblings('div.arguments-data').hide();
    });

    $('#trim-audit-log').click(function(e) {
        e.preventDefault();
        $.post(site_url+'api/system/trim_history', { type: 'audit' }, function(data) {
            data = JSON.parse(data);
            if (data.error) {
                alert(data.error);
            } else if (data.curl_response) {
                var response = JSON.parse(data.curl_response);
                if (response._indices.nagioslogserver_log._shards.failed == 0) {
                    alert('Trimmed Alert History to remove entries older than ' + data.days_to_trim + ' days.');
                }
            }
        });
    });
});

function update_datetimepicker() {
    if ($('.time-select').val() == 'c') {
        $('.date-picker').show();
    } else {
        $('.date-picker').hide();
    }
}
</script>

<div class="configure-layout">

    <?php echo $leftbar; ?>

    <div class="form-container">

        <div class="tw-flex tw-flex-row tw-justify-between">
            <div class="form-title" style="margin-bottom: 0px"><?php echo _("Audit Log"); ?></div>
            <div class="tw-flex tw-gap-4">
                <ui-sheet>
                    <ui-sheet-trigger>
                        <button class="ui-btn ui-btn-default">
                            <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                                <i class="material-symbols-outlined">filter_alt</i>                                
                                <?php echo _("Filter"); ?>
                            </div>
                        </button>
                    </ui-sheet-trigger>
                    <ui-sheet-content>
                        <div class="tw-flex tw-justify-between tw-items-center tw-mb-4">
                            <div class="form-header"><?php echo _("Filter Options"); ?></div>
                            <ui-sheet-close></ui-sheet-close>
                        </div>
                    <?php echo form_open('admin/audit-log', array('method' => 'get')); ?>
                        <div class="tw-grid tw-gap-4">
                            <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                                <label class="tw-text-right tw-font-medium tw-mb-0"><?php echo _('Time Frame'); ?></label>
                                <select class="time-select ui-select tw-col-span-2" name="time">
                                    <option value="24h"<?php if ($time == '24h' || $time == '') { echo ' selected'; } ?>><?php echo _('Last 24 Hours'); ?></option>
                                    <option value="7d"<?php if ($time == '7d') { echo ' selected'; } ?>><?php echo _('Last 7 Days'); ?></option>
                                    <option value="30d"<?php if ($time == '30d') { echo ' selected'; } ?>><?php echo _('Last 30 Days'); ?></option>
                                    <option value="c"<?php if ($time == 'c') { echo ' selected'; } ?>><?php echo _('Custom'); ?></option>
                                </select>
                            </div>
                            <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4 date-picker">
                                <label class="date-picker tw-text-right tw-font-medium tw-mb-0"><?php echo _('From'); ?></label>
                                <input type="text" name="start" class="date-picker ui-input tw-col-span-2" value="<?php if (!empty($start)) { echo $start; } ?>">
                            </div>
                            <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4 date-picker">
                                <label class="date-picker tw-text-right tw-font-medium tw-mb-0"><?php echo _('to'); ?></label>
                                <input type="text" name="end" class="date-picker ui-input tw-col-span-2" value="<?php if (!empty($end)) { echo $end; } ?>">
                            </div>
                            <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                                <label class="tw-text-right tw-font-medium tw-mb-0"><?php echo _('Type'); ?></label>
                                <select class="ui-select tw-col-span-2" name="type">
                                    <option value=""><?php echo _('All'); ?></option>
                                    <option value="JOBS"<?php if ($type == 'JOBS') { echo ' selected'; } ?>><?php echo _('JOBS'); ?></option>
                                    <option value="ALERT"<?php if ($type == 'ALERT') { echo ' selected'; } ?>><?php echo _('ALERT'); ?></option>
                                    <option value="INFO"<?php if ($type == 'INFO') { echo ' selected'; } ?>><?php echo _('INFO'); ?></option>
                                    <option value="SECURITY"<?php if ($type == 'SECURITY') { echo ' selected'; } ?>><?php echo _('SECURITY'); ?></option>
                                    <option value="CONFIG"<?php if ($type == 'CONFIG') { echo ' selected'; } ?>><?php echo _('CONFIG'); ?></option>
                                    <option value="MAINTENANCE"<?php if ($type == 'MAINTENANCE') { echo ' selected'; } ?>><?php echo _('MAINTENANCE'); ?></option>
                                    <option value="POLLER"<?php if ($type == 'POLLER') { echo ' selected'; } ?>><?php echo _('POLLER'); ?></option>
                                    <option value="BACKUP"<?php if ($type == 'BACKUP') { echo ' selected'; } ?>><?php echo _('BACKUP'); ?></option>
                                </select>
                            </div>
                            <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                                <label class="tw-text-right tw-font-medium tw-mb-0"><?php echo _('Message'); ?></label>
                                <input type="text" name="search" class="ui-input tw-col-span-2" value="<?php echo $search; ?>" placeholder="<?php echo _("Search message..."); ?>">
                            </div>
                        </div>
                        <div class="tw-flex tw-justify-end tw-mt-4">
                            <button type="submit" class="ui-btn ui-btn-default">
                                <div class="tw-flex tw-items-center tw-justify-center">
                                    <?php echo _('Submit'); ?>
                                </div>
                            </button>
                        </div>
                        <?php echo form_close(); ?>
                    </ui-sheet-content>
                </ui-sheet>
                <button id="trim-audit-log" class="ui-btn ui-btn-outlined">
                    <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                        <i class="material-symbols-outlined">content_cut</i> 
                        <?php echo _('Trim Audit Log'); ?>
                    </div>
                </button>
            </div>
        </div>
        <div class="form-spacer"></div>
        <div class="tw-flex tw-justify-between tw-my-4 tw-items-center">
            <?php
            if (!empty($record_total)) {
                echo '<span class="form-subheader">' . _('Page') . ' ' . $page . ' of ' . $total_pages . ' &nbsp;&middot;&nbsp; ';
                if (!empty($limiting)) {
                    echo $limiting . ' (' .  number_format($record_total) .  ' ' . _('total records') . ')';
                } else {
                    echo number_format($record_total) .  ' ' . _('records');
                }
                echo '</span>';
            } else {
                echo '<span class="form-subheader">0 ' . _(' records') . '</span>';
            }
            ?>
            <div class="ui-pagination">
                <?php echo $pagination; ?>
            </div>
        </div>

        <table class="ui-table">
            <thead class="ui-thead">
                <tr class="ui-tr">
                    <th class="ui-th"><?php echo _('Created By'); ?></th>
                    <th class="ui-th"><?php echo _('Type'); ?></th>
                    <th class="ui-th"><?php echo _('Created At'); ?></th>
                    <th class="ui-th"><?php echo _('Message'); ?></th>
                    <th class="ui-th"><?php echo _('Instance ID'); ?></th>
                    <th class="ui-th"><?php echo _('Source'); ?></th>
                    <th class="ui-th"></th>
                </tr>
            </thead>
            <tbody class="ui-tbody">
                <?php
                if (count($logs) > 0) {
                    foreach ($logs as $log) {
                ?>
                <tr class="ui-tr">
                    <td class="ui-td"><?php echo htmlentities($log['_source']['created_by'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td class="ui-td"><?php echo $log['_source']['type']; ?></td>
                    <td class="ui-td"><?php echo date('r', ($log['_source']['created'] / 1000)); ?></td>
                    <td class="ui-td">
                        <td-overflow class="tw-max-w-[500px]">
                            <td-overflow-content class="tw-font-geist-mono geist-mono">
                                <?php echo $log['_source']['message']; ?>
                            </td-overflow-content>
                        </td-overflow>
                    </td>
                    <td class="ui-td"><?php if (@isset($log['_source']['node'])) { echo $log['_source']['node']; } ?></td>
                    <td class="ui-td"><?php echo $log['_source']['source']; ?></td>
                    <td class="ui-td"><?php if (@isset($log['_source']['actions'])) { echo $log['_source']['actions']; } ?></td>
                </tr>
                <?php
                    }
                } else {
                ?>
                <tr class="ui-tr">
                    <td class="ui-td" colspan="7"><?php echo _("No logs matched your filters."); ?></td>
                </tr>
                <?php } ?>
            </tbody>
        </table>

        <div>
            <?php
            $url = (!empty($_SERVER['QUERY_STRING'])) ? 'admin/audit-log?' . htmlentities($_SERVER['QUERY_STRING'], ENT_COMPAT, 'UTF-8') : 'admin/audit-log';
            echo form_open($url, array('class' => 'pp-form'));
            ?>
            <input type="hidden" name="pp" class="pp" value="<?php echo intval($page_size); ?>">
            <?php echo form_close(); ?>
            <div class="tw-flex tw-justify-between tw-my-4 tw-items-center">
                <div class="tw-flex tw-gap-2">
                    <div class="tw-w-fit">
                        <div class="ui-input-group">
                            <div><?php echo _('Results per page'); ?></div>
                            <select class="ui-select results-per-page">
                                <option value="10"<?php if ($page_size == 10) { echo ' selected'; } ?>>10</option>
                                <option value="25"<?php if ($page_size == 25) { echo ' selected'; } ?>>25</option>
                                <option value="50"<?php if ($page_size == 50) { echo ' selected'; } ?>>50</option>
                                <option value="100"<?php if ($page_size == 100) { echo ' selected'; } ?>>100</option>
                                <option value="c"><?php echo _("Custom"); ?></option>
                                <?php if (!in_array($page_size, array(10, 25, 50, 100))) { echo '<option value="' . $page_size . '" selected>' . _('Custom') . ' - ' . $page_size . '</option>'; } ?>
                            </select>
                        </div>
                    </div>
                    <div class="custom-box hide">
                        <label class="tw-flex tw-gap-2">
                            <input type="text" size="4" class="ui-input custom tw-font-normal" placeholder="#" value="">
                            <button type="button" class="ui-btn ui-btn-outlined save-custom"><?php echo _("Save"); ?></button>
                        </label>
                    </div>
                </div>
                <div class="ui-pagination">
                    <?php echo $pagination; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>