<?php echo $header; ?>

<script type="text/javascript">
$(document).ready(function() {

    setup_form();

    // Activate tool tips
    $('.tt').tooltip();

    // Change what's displayed when the server type changes
    $('#type').change(function() {
        setup_form();
    });

    $('#encryption').change(function() {
        if ($(this).val() == "ssl") {
            $('#port').val(636);
        } else {
            $('#port').val(389);
        }
    })

});

function setup_form() {
    if ($('#type').val() == "ldap") {
        $('.ad-specific').hide();
        $('.ldap-specific').show();
    } else {
        $('.ad-specific').show();
        $('.ldap-specific').hide();
    }
}
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <h1 class="form-title"><?php echo _('Edit LDAP / AD Server'); ?></h1>
        <p class="form-subtitle tw-mb-2"><?php echo _('You must make sure that you can access the LDAP / Active Directory server from your Nagios Log Server box. You should also verify that the correct encryption methods are available. If you\'re planning on using SSL or TLS with self-signed certificates you need to make sure the proper certificates are installed on the Nagios Log Server server or you will not be able to connect to your LDAP / Active Directory server.'); ?></p>
        <div class="form-spacer"></div>

        <div class="alert alert-danger <?php if (empty($errors)) { echo "hide"; } ?>" style="margin-bottom: 10px;">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <?php if (!empty($errors)) { echo $errors; } ?>
        </div>
        
        <?php echo form_open('admin/edit_auth_server/'.$id); ?>
            <div class="tw-w-2/5">
                <div class="tw-grid tw-mb-2 tw-pt-2 tw-w-full tw-items-center">
                    <label class="tw-block tw-text-sm tw-font-medium" for="type"><?php echo _('Server Type'); ?></label>
                    <select id="type" class="ui-select" name="type">
                        <option value="ad" <?php if (!empty($type)) { if ($type == "ad") { echo "selected"; } } ?>>Active Directory</option>
                        <option value="ldap" <?php if (!empty($type)) { if ($type == "ldap") { echo "selected"; } } ?>>LDAP</option>
                    </select>
                </div>
                <div class="ui-checkbox-group tw-mb-4">
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="checkbox" id="checkbox1" name="enabled" value="1" class="ui-checkbox-group-item" <?php if (!isset($enabled)) { echo "checked"; } else { if (!empty($enabled)) { echo "checked"; } } ?>>
                        <label for="checkbox1" class="ui-label"><?php echo _("Enabled");?></label>
                        <tooltip-provider>
                            <tooltip data-position="right" data-delay="100">
                                <tooltip-trigger class="tw-flex">
                                    <span class="material-symbols-outlined base">help</span>
                                </tooltip-trigger>
                                <tooltip-content>
                                    <div class="tw-w-80 tw-max-w-80" style="text-wrap:wrap;">
                                        <?php echo _('Enabled servers can be used to authenticate against. Disabling a server means the users will still exist but they won\'t be able to log into Nagios Log Server.'); ?>
                                    </div>
                                </tooltip-content>
                            </tooltip>
                        </tooltip-provider>
                    </div>
                </div>

                <div class="tw-grid tw-mb-4 tw-w-full tw-items-center">
                    <label class="tw-block tw-text-sm tw-font-medium" for="name"><?php echo _('Server Name'); ?></label>
                    <input type="text" id="name" class="ui-select" name="name" value="<?php if (!empty($name)) { echo html_escape($name); } ?>">
                    <div class="form-subtext"><?php echo _('The name of the server for internal purposes only. This will not affect the connection.'); ?></div>
                </div>
                
                <div class="tw-grid tw-mb-4 tw-w-full tw-items-center">
                    <label class="tw-block tw-text-sm tw-font-medium" for="basedn"><?php echo _('Base DN'); ?></label>
                    <input type="text" id="basedn" class="ui-input" name="basedn" value="<?php if (!empty($basedn)) { echo html_escape($basedn); } ?>" placeholder="DC=nagios,DC=com">
                    <div class="form-subtext"><?php echo _('The LDAP-format starting object (distinguished name) that your users are defined below, such as <strong>DC=nagios,DC=com</strong>.'); ?></div>
                </div>
                <div class="tw-grid tw-mb-4 tw-w-full tw-items-center ad-specific hide">
                    <label class="tw-block tw-text-sm tw-font-medium" for="suffix"><?php echo _('Account Suffix'); ?></label>
                    <input type="text" id="suffix" class="ui-input" name="suffix" value="<?php if (!empty($suffix)) { echo html_escape($suffix); } ?>" placeholder="@nagios.com">
                    <div class="form-subtext"><?php echo _('The part of the full user identification after the username, such as <strong>@nagios.com</strong>.'); ?></div>
                </div>
                <div class="tw-grid tw-mb-4 tw-w-full tw-items-center ad-specific hide">
                    <label class="tw-block tw-text-sm tw-font-medium" for="controllers"><?php echo _('Domain Controllers'); ?></label>
                    <input type="text" id="controllers" class="ui-input" name="controllers" value="<?php if (!empty($controllers)) { echo html_escape($controllers); } ?>" placeholder="dc1.nagios.com,dc2.nagios.com">
                    <div class="form-subtext"><?php echo _('A <strong>comma-separated</strong> list of domain controllers.'); ?></div>
                </div>
                <div class="tw-grid tw-mb-4 tw-w-full tw-items-center ldap-specific hide">
                    <label class="tw-block tw-text-sm tw-font-medium" for="host"><?php echo _('LDAP Host'); ?></label>
                    <input type="text" id="host" class="ui-input" name="host" value="<?php if (!empty($host)) { echo html_escape($host); } ?>" placeholder="ldap.nagios.com">
                    <div class="form-subtext"><?php echo _('The IP address or hostname of your LDAP server.'); ?></div>
                </div>
                <div class="tw-grid tw-mb-4 tw-w-full tw-items-center ldap-specific hide">
                    <label class="tw-block tw-text-sm tw-font-medium" for="port"><?php echo _('LDAP Port'); ?></label>
                    <input type="text" id="port" class="ui-input" name="port" value="<?php if (!empty($port)) { echo html_escape($port); } else { echo "389"; } ?>">
                    <div class="form-subtext"><?php echo _('The port your LDAP server is running on. (Default is 389)'); ?></div>
                </div>
                <div class="tw-grid tw-mb-4 tw-w-full tw-items-center">
                    <label class="tw-block tw-text-sm tw-font-medium" for="encryption"><?php echo _('Encryption Method'); ?></label>
                    <select id="encryption" class="ui-select" name="encryption">
                        <option value="none" <?php if (!empty($encryption)) { if ($encryption == "none") { echo "selected"; } } ?>>None</option>
                        <option value="ssl" <?php if (!empty($encryption)) { if ($encryption == "ssl") { echo "selected"; } } ?>>SSL/TLS</option>
                        <option value="tls" <?php if (!empty($encryption)) { if ($encryption == "tls") { echo "selected"; } } ?>>STARTTLS</option>
                    </select>
                    <div class="form-subtext"><?php echo _('The type of security (if any) to use for the connection to the server(s). The STARTTLS option may use a plain text connection if the server does not upgrade the connection to TLS.'); ?></div>
                </div>
            </div>
            <div class="clear"></div>
            <div class="tw-flex tw-gap-4">
                <button type="submit" name="save" value="1" class="ui-btn ui-btn-default"><?php echo _('Save Server'); ?></button>
                <a href="<?php echo site_url('admin/auth_servers'); ?>" class="no-primary ui-btn ui-btn-outlined"><?php echo _('Cancel'); ?></a>
            </div>
        <?php echo form_close(); ?>

    </div>
</div>

<?php echo $footer; ?>