<?php echo $header; ?>



<script language="javascript" type="text/javascript">
// Store the selected users for multiple requests
var SELECTED_USERS = [];
var SELECTED_USERNAMES = [];
var SERVER_TYPE = '<?php echo $server_type; ?>';

$(document).ready(function() {

    // Get the default root folders
    ad_generate_root();

    // When clicking on a folder we actually show the users/folders
    $('#root').on('click', '.ad-folder', function(e) {
        if (!$(this).parents('ul').hasClass('sub-list') && !$(this).hasClass('active') && $(this).parent().has('ul').length == 0) {
            $('.sub-list').remove();
        }

        $('.ad-folder').removeClass('active');
        $(this).addClass('active');

        var path = $(this).data('path');
        var type = $(this).data('type');
        grab_ad_obj('view', type, path, this);
    });

    // Select a user
    $('#view').on('change', '.ad-checkbox', function(e) {
        if ($(this).is(":checked")) {
            if (SELECTED_USERS.indexOf($(this).val()) == -1) {
                SELECTED_USERS.push($(this).val());
            }
            if (SELECTED_USERNAMES.indexOf($(this).data('displayname')) == -1) {
                SELECTED_USERNAMES.push($(this).data('displayname'));
            }
        } else {
            // Remove user from the list if we are un-checking it
            var i = SELECTED_USERS.indexOf($(this).val());
            if (i > -1) { SELECTED_USERS.splice(i, 1); }
            var i = SELECTED_USERNAMES.indexOf($(this).data('displayname'));
            if (i > -1) { SELECTED_USERNAMES.splice(i, 1); }
        }

        // Update user count at top of page
        var num = SELECTED_USERS.length;
        $('#selected-users .user-count').html(num);
        var html = "";
        if (num > 0) {
            html = ": "+SELECTED_USERNAMES.join(', ');
        }
        $('#selected-users .users').html(html);

        $('#objs').val(SELECTED_USERS.join('|'));
    });

    $("#view").on('click', '.user-toggle-show-dn', function(e) {
        var userdn = $(this).parents('li').find('.user-dn');
        if (userdn.css("display") == "none") {
            userdn.show();
            $(this).removeClass('fa-plus-square-o').addClass('fa-minus-square-o');
        } else {
            userdn.hide();
            $(this).removeClass('fa-minus-square-o').addClass('fa-plus-square-o');
        }
    });

    $("#view").on('click', '.toggle-users', function(e) {
        var text = $(this).parents('label').find('span');
        if ($(this).prop('checked')) {
            $('.ad-checkbox:not(:disabled)').prop('checked', true).trigger('change');
            text.html('<?php echo _("Select None"); ?>');
        } else {
            $('.ad-checkbox:not(:disabled)').prop('checked', false).trigger('change');
            text.html('<?php echo _("Select All"); ?>');
        }
    });

    $('#select-users').click(function() {
        if ($('#objs').val() == '') {
            alert("<?php echo _('Must select at least one user to import.'); ?>");
            return false;
        }
    });

    $("#view").on('click', '#ad-search-btn', function(e) {
        var type = $('.ad-folder.active').data('type');
        var path = $('.ad-folder.active').data('path');
        var search = $('#ad-search').val();
        grab_ad_obj('view', type, path, this, search);
    });

    $("#view").on('keypress', '#ad-search', function(e) {
        if (e.which === 13) {
            $("#ad-search-btn").trigger('click');
        }
    });

    $("#view").on('click', '#ad-search-clear-btn', function(e) {
        var path = $('.ad-folder.active').data('path');
        var type = $('.ad-folder.active').data('type');
        grab_ad_obj('view', type, path, this);
    });

    $("#view").on('click', '.ad-page-btn', function(e) {
        var type = $('.ad-folder.active').data('type');
        var path = $('.ad-folder.active').data('path');
        var search = $('#ad-search').val();
        var target_page = $(this).val();
        var page_size = $('#current-page-size').val();
        grab_ad_obj('view', type, path, this, search, target_page, page_size);
    });

    $('body').on('keypress', '#ad-pager-page-number', function(e) {
        if (e.keyCode == 13) {
            var type = $('.ad-folder.active').data('type');
            var path = $('.ad-folder.active').data('path');
            var search = $('#ad-search').val();
            var target_page = $(this).val();
            var page_size = $('.num-records').val();
            grab_ad_obj('view', type, path, this, search, target_page, page_size);
        }
    });

    $('body').on('change', '.num-records', function(e) {
        var type = $('.ad-folder.active').data('type');
        var path = $('.ad-folder.active').data('path');
        var search = $('#ad-search').val();

        var current_page = $('#ad-pager-page-number').val();
        var current_page_size = $('#current-page-size').val();
        var new_page_size = $(this).val();
        var new_page = Math.ceil(((current_page - 1) * current_page_size + 1) / new_page_size);

        grab_ad_obj('view', type, path, this, search, new_page, new_page_size);
    });

});

function grab_ad_obj(target_form, type, path, folder, search='', target_page=1, page_size=50)
{
    already_loaded = $(folder).parent().has('ul').length;
    var json_path = JSON.stringify(path);
    var target_form = "#" + target_form;
    if (already_loaded == 0) {
        $.ajax({
            type: "POST",
            url: site_url + "api/system/get_nav_window",
            data: { object_type: type, target_path: json_path },
            success: function(response) {
                response = JSON.parse(response);
                if (response != "") {
                    // Check the level of the folder and add padding if necessary
                    var sub = $(folder).parents('ul').length;
                    var x = sub * 20;
                    $(folder).parent().append(response[0]);
                    $(folder).parent().find('ul').find('span.ad-folder').css('padding-left', x+'px');
                }
                grab_ad_users(target_form, type, json_path, search, target_page, page_size);
            },
            error: function(response) { console.log("<?php echo _('Error: Unable to connect to LDAP server.'); ?>"); }
        });
    } else {
        grab_ad_users(target_form, type, json_path, search, target_page, page_size);
    }
}

function ad_generate_root() {
    var target = "#root";
    var type = "container";
    $.ajax({
        type: "POST",
        url: site_url + "api/system/get_nav_window",
        data: { object_type: type, target_path: "", new_list: "1" },
        success: function(response) {
            response = JSON.parse(response);
            $(target).html(response[0]);
            if (response[1])
            {
                grab_ad_users('#view', 'organizationalUnit', '');
            }
        },
        error: function(response) { console.log("<?php echo _('Error: Unable to connect to LDAP server.'); ?>"); }
    });
}

function grab_ad_users(target_form, type, json_path, search, target_page, page_size) {
    $.ajax({
        type: "POST",
        url: site_url + "api/system/get_ldap_ad_users",
        data: {
            object_type: type,
            target_path: json_path,
            selected: JSON.stringify(SELECTED_USERS),
            search: search,
            target_page: target_page,
            page_size: page_size
        },
        success: function(response) {
            $(target_form).html(response);

            // Go through and verify that all users are checked that need to be

        },
        error: function(response) { console.log("<?php echo _('Error: Unable to connect to LDAP server.'); ?>"); }
    });
}
    
function toggle_boxes(element) {
    $(element.parentNode).children().attr("checked", "true");
    toggle_user_add();
}

</script>

<?php $current_page = 1; $page_count = 50; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <h1 class="form-title"><?php echo _('LDAP / AD Import Users'); ?></h1>
        <p class="form-subtitle"><?php echo _('Select the users you would like to give access to Log Server via LDAP / Active Directory authentication. You will be able to set user-specific permissions on the next page.'); ?></p>
        <h4 class="form-header"><?php echo _('Select Users to Import'); ?></h4>
        <p id="selected-users" class="tw-my-2"><strong class="user-count">0</strong> <?php echo _('users selected for import'); ?><strong class='users'></strong></p>

        <div class="tw-inline-flex ad-ldap-wrapper tw-border">
            <div id="root" class="tw-min-w-[300px] tw-table-cell tw-bg-transparent tw-border-r tw-border-border tw-align-top"></div>
            <div id="view" class="tw-w-[900px] tw-table-cell tw-align-top tw-overflow-y-auto">
                <ul class="ad-list user-list">
                    <li>&nbsp;</li>
                </ul>
            </div>
        </div>

        <?php echo form_open('admin/users/import/step2'); ?>
        <div class="tw-mt-8">
            <input type="hidden" value="" name="objs" id="objs">
            <button type="submit" id="select-users" class="ui-btn ui-btn-default"><?php echo _('Add Selected Users'); ?>
                <span class="material-symbols-outlined">chevron_right</span>
            </button>
        </div>
        <?php echo form_close(); ?>

    </div>
</div>

<?php echo $footer; ?>