<?php echo $header; ?>

<script type="text/javascript">
$(document).ready(function() {

    $("#test-settings").bind('click', function() {
        btn = $(this);
        btn.button('loading');
        postvars = { '<?php echo $csrf['name']; ?>': '<?php echo $csrf['hash']; ?>' }
        url = '<?php echo site_url('admin/test_mail_settings') ?>';
        $.post(url, postvars, function(data) {
            if (data.result == 'success') {
                $('#test-success').html('<?php echo _('The email was sent successfully to'); ?> <b>' + data.email + '</b> <?php echo _('Check your inbox to ensure you received the message'); ?>.').show();
                $('#test-error').hide();
            } else {
                $('#test-success').hide();
                $('#test-error').html(data.msg).show();
            }
            btn.button('reset');
        }, 'json');
        return false;
    });

    $('#email_method').change(function() {
        var method = $(this).val();
        if (method == "smtp") {
            $('#smtp-settings').show();
        } else {
            $('#smtp-settings').hide();
        }
    });

});
</script>
<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">
        <h1 class="form-title"><?php echo _('Mail Settings'); ?></h1>
        <p class="form-subtitle"><?php echo _('Set the settings for sending outgoing mail such as notifications. From and Reply-to names and emails are defaulted to what is shown below.'); ?></p>
        <div class="form-spacer"></div>

        <?php if (!empty($success)) { ?><div class="alert alert-info tw-my-2.5 tw-mx-0"><?php echo $success; ?></div><?php } ?>
        <?php if (!empty($error)) { ?><div class="alert alert-error tw-my-2.5 tw-mx-0"><?php echo $error; ?></div><?php } ?>
    
        <div id="test-error" class="alert alert-error hide tw-my-2.5 tw-mx-0"></div>
        <div id="test-success" class="alert alert-success hide tw-my-2.5 tw-mx-0"></div>

        <?php echo form_open('admin/mail', array("class" => "form-horizontal")); ?>
        <div class="tw-flex tw-flex-col tw-gap-2 tw-w-1/2">
            <div class="tw-mb-4">
                <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="email_from"><?php echo _("From Email"); ?></label>
                <div class="tw-flex tw-gap-2">
                    <input type="text" class="ui-input tw-w-1/3" id="email_from_name" name="email_from_name" value="<?php echo htmlentities($email_from_name, ENT_COMPAT, 'UTF-8'); ?>" placeholder="<?php echo _('Nagios Log Server'); ?>">
                    <input type="text" id="email_from" class="ui-input tw-w-2/3" name="email_from" value="<?php echo htmlentities($email_from, ENT_COMPAT, 'UTF-8'); ?>" placeholder="logserver@mydomain.com">
                </div>
            </div>

            <div class="tw-mb-4">
                <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="email_reply_to"><?php echo _("Reply-To Email"); ?></label>
                <div class="tw-flex tw-gap-2">
                    <input type="text" class="ui-input tw-w-1/3" id="email_reply_to_name" name="email_reply_to_name" value="<?php echo htmlentities($email_reply_to_name, ENT_COMPAT, 'UTF-8'); ?>" placeholder="<?php echo _('Nagios Log Server'); ?>">
                    <input type="text" id="email_reply_to" class="ui-input tw-w-2/3" name="email_reply_to" value="<?php echo htmlentities($email_reply_to, ENT_COMPAT, 'UTF-8'); ?>" placeholder="root@localhost">
                </div>
            </div>

            <div class="tw-mb-4">
                <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="email_method"><?php echo _("Send Email Method"); ?></label>
                <select name="email_method" class="ui-select tw-w-full" id="email_method">
                    <option value="mail" <?php if ($email_method == 'mail') { echo "selected"; } ?>><?php echo _("PHP Mail"); ?></option>
                    <option value="smtp" <?php if ($email_method == 'smtp') { echo "selected"; } ?>><?php echo _("SMTP Server"); ?></option>
                </select>
            </div>

            <div id="smtp-settings" <?php if ($email_method == 'mail' || empty($email_method)) { echo 'class="tw-hidden"'; } ?>>
                <div class="tw-mb-4">
                    <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="smtp_host"><?php echo _("SMTP Server Address"); ?></label>
                    <input type="text" class="ui-input tw-w-full" name="smtp_host" value="<?php echo $smtp_host; ?>" id="smtp_host">
                </div>

                <div class="tw-mb-4">
                    <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="smtp_crypto"><?php echo _("SMTP Security"); ?></label>
                    <select name="smtp_crypto" class="ui-select tw-w-full" id="smtp_crypto">
                        <option value="" <?php if (empty($smtp_crypto)) { echo "selected"; } ?>>None</option>
                        <option value="ssl" <?php if ($smtp_crypto == 'ssl') { echo "selected"; } ?>>SSL</option>
                        <option value="tls" <?php if ($smtp_crypto == 'tls') { echo "selected"; } ?>>TLS or STARTTLS</option>
                    </select>
                </div>

                <div class="tw-mb-4">
                    <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="smtp_port"><?php echo _("SMTP Port"); ?></label>
                    <input type="text" class="ui-input tw-w-20" name="smtp_port" value="<?php if (!empty($smtp_port)) { echo $smtp_port; } else { echo '25'; } ?>" placeholder="25" id="smtp_port">
                </div>

                <div class="tw-mb-4">
                    <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="smtp_user"><?php echo _("SMTP Username"); ?></label>
                    <input type="text" class="ui-input tw-w-full" name="smtp_user" value="<?php echo $smtp_user; ?>" id="smtp_user">
                </div>

                <div class="tw-mb-4">
                    <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="smtp_pass"><?php echo _("SMTP Password"); ?></label>
                    <input type="password" class="ui-input tw-w-full" name="smtp_pass" value="<?php echo $smtp_pass; ?>" id="smtp_pass">
                </div>
            </div>

            <div class="tw-mb-4">
                <div class="ui-checkbox-group">
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="checkbox" id="email_text_only" name="email_text_only" value="1" <?php if ($email_text_only) { echo 'checked'; } ?> class="ui-checkbox-group-item">
                        <label for="email_text_only" class="ui-label"><?php echo _("Send emails as text only (no HTML)"); ?></label>
                    </div>
                </div>
            </div>

            <div class="tw-mt-4 tw-flex tw-gap-2">
                <button type="submit" class="ui-btn ui-btn-default"><?php echo _("Save Settings"); ?></button>
                <button 
                    <?php if (is_demo_mode()) { echo "disabled"; } ?> 
                    autocomplete="false" 
                    id="test-settings" 
                    data-toggle="button" 
                    data-loading-text="<?php echo _('Please wait'); ?>..." 
                    class="ui-btn ui-btn-outlined"
                >
                    <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                        <div class="material-symbols-outlined">mail</div>
                        <?php echo _('Test Settings'); ?>
                    </div>
                </button>
            </div>
        </div>
        <?php echo form_close(); ?>
        <div class="tw-clear tw-pb-[100px]"></div>
    </div>
</div>

<?php echo $footer; ?>