<?php echo $header; ?>

<script type="text/javascript">
    var lastChecked = null;

    function isValidHost(ip) {
        const ip4test = /^(\d{1,3}\.){3}\d{1,3}$/;
        // TODO: Add hostname and compressed ipv6 check
        const ip6test = /^([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$/;

        return ip4test.test(ip) || ip6test.test(ip);
    }

    function getIndexStatus(index) {
        const sourceIndexData = sourceIndexStatus[index];
        $('#migration-status-header').text( _('Migration Status for ') + sourceIndexData.index);
       
        $('#status-migrated-doc-count').html('<div class="spinner"></div>');
        $('#status-migrated-elapsed-time').html('<div class="spinner"></div>');
        $('#status-percent-migrated').html('<div class="spinner"></div>');

        // Fetch the migrated data status
        const reqBody = {
            source_ip: $('#get-indices-ip').val(),
            index: sourceIndexData.index
        }

        var elapsed_time = 0;
        var total_docs = 0;
        var created_docs = 0;
        var updated_docs = 0;

        $.ajax({
            url: site_url + 'api/migration/get_migration_status',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(reqBody),
            dataType: 'json',
            success: function(data) {
                if (data.found) {
                    data._source.log_range.forEach(range => {
                        if (!isNaN(range.results.took)) {
                            elapsed_time += range.results.took;
                        }
                        if (!isNaN(range.results.total)) {
                            total_docs += range.results.total;
                        }
                        if (!isNaN(range.results.created)) {
                            created_docs += range.results.created;
                        }
                        if (!isNaN(range.results.updated)) {
                            updated_docs += range.results.updated;
                        }
                    })
                }

                if (total_docs > sourceIndexData['docs.count']) {
                    total_docs = sourceIndexData['docs.count'];
                }

                const percentComplete = total_docs / sourceIndexData['docs.count'] * 100;

                const hours = Math.floor(elapsed_time / 3600000);
                const minutes = Math.floor((elapsed_time % 3600000) / 60000);
                const seconds = Math.floor((elapsed_time % 60000) / 1000);

                $('#status-migrated-doc-count').html(total_docs);
                $('#status-migrated-elapsed-time').html(`${hours}:${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`);
                $('#status-percent-migrated').html(percentComplete.toFixed(0) + "%");
            }
        });

        $('#migration-status').modal('show');
    }

    function enableStartMigrationButton() {
        const enableStart =$('input[name="sel"]:checked').length > 0 || $('#nagios-logserver-metadata').is(':checked');
        $('#start-migration').prop('disabled', !enableStart);
    }


    function add_checkbox_magic() {
        var $chkboxes = $('input[name="sel"]');
        $chkboxes.click(function(e) {
            enableStartMigrationButton();
            if (!lastChecked) {
                lastChecked = this;
                return;
            }
            if (e.shiftKey) {
                var start = $chkboxes.index(this);
                var end = $chkboxes.index(lastChecked);
                $chkboxes.slice(Math.min(start,end), Math.max(start,end)+ 1).prop('checked', lastChecked.checked);
            }
            lastChecked = this;
        });
    }

    var sourceIndexStatus = [];
    let reconfigureCountdown = null;

    $(document).ready(function() {

        function startReconfigureCountdown() {
        let countdown = 59;
        reconfigureCountdown = setInterval(() => {
            if (countdown <= 0) {
                clearInterval(reconfigureCountdown);
                $('#reconfigure-countdown').addClass('hide');
            } else {
                $('#reconfigure-countdown').text(countdown + ' seconds remaining');
                countdown--;
            }
        }, 1000);
    }

        function showClosedIndicesMessage(showMessage, serverip) {
            var closedIndexMessage = '<?php echo _("There are closed indices on "); ?>' + serverip + '.';
            closedIndexMessage += ' <?php echo _("Nagios Log Server cannot migrate data from indices that are closed."); ?> ';
            closedIndexMessage += '<?php echo _("Those indices will not appear in the index selection list"); ?>';
            closedIndexMessage += '. <a target="_blank" href="http://' + serverip;
            closedIndexMessage += '/nagioslogserver/admin/index_status"><?php echo _('Click Here'); ?></a> ';
            closedIndexMessage += ' <?php echo _("to go to the index status page to open them."); ?>';
            $('#closed-indices-message').html(closedIndexMessage);
            if (showMessage) {
                $('#closed-indices').modal('show');
            }
        }

        function parseMigrationSourceData(data) {
            const serverip = $('#check-server-ip').val();
            var data_array = $.parseJSON(data);
            enableStartMigrationButton();
            var closedIndices = false;
            data_array.forEach(index => {
                var disabled = false;
                if (index.status !== 'open') {
                    closedIndices = true;
                    disabled = true;
                    }
                const row = `
                    <tr class="ui-tr">
                        <td class="ui-td">
                        ${disabled ? '' :
                            `<div class="tw-flex tw-items-center">
                                <input class="ui-checkbox-group-item" type="checkbox" name="sel" value="${index.name}" id="${index.name}">
                            </div>`
                        }
                        </td>
                        <td class="ui-td">
                            ${index.name}
                        </td>
                        <td class="ui-td">
                            ${index.status === 'close' ? "Closed" : "Open"}
                        </td>
                    </tr>
                `;
                $('#available-indices-table tbody').append(row);
            });
            $('#cb-toggle').click(function() {
                if ($(this).is(':checked')) {
                    $('input[name="sel"]').prop('checked', true);
                } else {
                    $('input[name="sel"]').prop('checked', false);
                }
                enableStartMigrationButton();
            });
            add_checkbox_magic();
            showClosedIndicesMessage(closedIndices, serverip);
            $("#index-selection").show();
        }

        function testRemoteReindex() {
            const serverip = $('#check-server-ip').val();
            $.ajax({
                url: site_url + 'api/migration/check_migration_source/' + serverip,
                type: 'POST',
                success: (data) => { parseMigrationSourceData(data) },
                error: function(jqHXR, textStatus, errorThrown) {
                    if (jqHXR.status === 403) {
                        console.log("Session ended. redirecting to login");
                        window.location.href = '/nagioslogserver/login?redirect=admin/migration';
                    }
                    $('#migration-source-listen').prop('href', 'http://' + serverip + '/nagioslogserver/admin/globals');
                    $('#migration-check-error').modal('show');
                }
            });
        }

        function checkServer() {
            const serverip = $('#check-server-ip').val();
            if (!isValidHost(serverip)) {
                alert(serverip + " is not a valid host");
                return;
            }
            $('#available-indices-table tbody').empty();
            $('#configure-opensearch-message').show();
            $('#configure-opensearch').show();
            $('#reconfigure-countdown').hide();
            $('#reconfigure-countdown').text('60 seconds remaining');
            $('#configure-opensearch-ok').hide();
            $('#configure-opensearch-failed').hide();

            $.ajax({
                url: site_url + 'api/migration/test_remote_reindex/' + serverip,
                type: 'POST',
                success: () => { testRemoteReindex(); },
                error: function(data) {
                    if (data.status === 403) {
                        console.log("Session ended. redirecting to login");
                        window.location.href = '/nagioslogserver/login?redirect=admin/migration';
                    } else {
                        $('#opensearch-config-error').modal('show');
                    }
                }
            });
        }

        $('#configure-opensearch-ok').click(function() {
            $('#opensearch-config-error').modal('hide');
            window.location.reload();
        });

        $('#check-server').click(checkServer);

        $('#get-indices').click(function() {
            const serverip = $('#get-indices-ip').val();
            if (!isValidHost(serverip)) {
                alert(serverip + " is not a valid host");
                return;
            }
            $('#get-indices').html('<span class="spinner"></span>Loading...');
            $("#check-index-selection").hide();
            $('#available-indices-status-table tbody').empty();
            $.ajax({
                url: site_url + 'api/migration/get_source_doc_info/' + serverip,
                type: 'POST',
                success: function(data) {
                    $('#get-indices').html(_('Get Indices'));
                    sourceIndexStatus = $.parseJSON(data);
                    for (const index of Object.entries(sourceIndexStatus)) {
                        if (index[1].status === 'open') {
                            const row = `
                                <tr class="ui-tr">
                                    <td class="ui-td">${index[0]}</td>
                                    <td class="ui-td">${index[1]["docs.count"]}</td>
                                    <td class="ui-td">${index[1]["pri.store.size"].toUpperCase()}</td>
                                    <td class="ui-td tw-flex tw-items-center">
                                        <div class="ui-icon-btn material-symbols-outlined" value=${index[0]} onClick="getIndexStatus('${index[0]}');">autorenew</div>
                                    </td>
                                </tr>
                            `;

                            $('#available-indices-status-table tbody').append(row);
                        }
                    };
                    $("#check-index-selection").show();
                },
                error: function(xhr, status, error) {
                    $('#get-indices').html(_('Get Indices'));
                    $('#migration-status-error').modal('show');
                } 
            });
        });

        function sortSelect(selectId) {
            var options = $('select' + selectId + ' option');
            var arr = options.map(function(_, o) { 
                return { t: $(o).text(), v: o.value, i: o.id }; }).get();
            arr.sort(function(o1, o2) { return o1.t > o2.t ? 1 : o1.t < o2.t ? -1 : 0; });
            options.each(function(i, o) {
                o.value = arr[i].v;
                o.id = arr[i].i;
                $(o).text(arr[i].t);
            });
        }

        function moveElement(id, source, dest) {
            $(source + ' option#' + id).detach().appendTo(dest);
            sortSelect(source);
            sortSelect(dest);
        }

        $('#nagios-logserver-metadata').click(function() {
            enableStartMigrationButton();
        });

        $('#start-migration').click(function () {
            const indices = [];

            const serverip = $('#check-server-ip').val();
            if (!isValidHost(serverip)) {
                alert(serverip + " is not a valid host");
                return;
            }

            const forceReindex = $('#force-index').is(':checked');
            const migrateLogServerMetaData = $('#nagios-logserver-metadata').is(':checked');

            $('input[name="sel"]:checked').each((index, element) => {
                indices.push(element.id);
            });

            reqBody = {
                server: serverip,
                indices: indices,
                forceReindex: forceReindex,
                migrateLogServerMetaData: migrateLogServerMetaData
            };

            $.ajax({
                url: site_url + 'api/migration/start_migration',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(reqBody),
                dataType: 'json',
                success: function(data) {
                    alert('Migrations have started. Click the status tab to monitor the status.');
                },
                error: function(data, textStatus, errorThrown) {
                    alert('Migrations failed. Please check the logs for more information.');
                }
            });
        });

        $('#configure-opensearch').click(function() {
            const serverip = $('#check-server-ip').val();
            if (!isValidHost(serverip)) {
                alert(serverip + " is not a valid host");
                return;
            }

            $('#configure-opensearch').hide();
            $('#reconfigure-countdown').show();

            startReconfigureCountdown();

            $.ajax({
                url: site_url + 'api/migration/reconfigure_opensearch/' + serverip,
                type: 'POST',
                success: function() {
                    clearInterval(reconfigureCountdown);
                    $('#opensearch-config-error').modal('hide');
                    testRemoteReindex();
                },
                error: function() {
                    $('#configure-opensearch-message').hide();
                    $('configure-opensearch').hide();
                    $('#reconfigure-countdown').hide();
                    $('#configure-opensearch-failed').show();
                    $('#configure-opensearch-ok').show();
                }
            });
        });

        $('#check-server-ip').on('keydown', function (event) {
            if (event.which === 13) {
                event.preventDefault();
                $('#check-server').click();
            }
        });

        $('#get-indices-ip').on('keydown', function (event) {
            if (event.which === 13) {
                event.preventDefault();
                $('#get-indices').click();
            }
        });
        
    });

</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">
        <div class="form-title"><?php echo _('Migrate Data'); ?></div>
        <div class="form-subtitle"><?php echo _('Migrate from a previous version of log server.'); ?></div>
        <div class="form-spacer"></div>
        <ui-tabs default-value="setup">
            <tabs-list>
                <tabs-trigger value="setup"><?php echo _('Migration Setup'); ?></tabs-trigger>
                <tabs-trigger value="status"><?php echo _('Migration Status'); ?></tabs-trigger>
            </tabs-list>
            <tabs-content value="setup">
                <div class="tw-w-1/4 tw-pb-2">
                    <div class="tw-mb-2 tw-w-full">
                        <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("Source Log Server Host"); ?></label>
                        <input class="ui-input" id='check-server-ip' type="text" placeholder="127.0.0.1" >
                        <button class="ui-btn ui-btn-default tw-mt-6" id="check-server"><?php echo _("Check Server Connection"); ?></button>
                    </div>
                </div>
                <div id="index-selection" style="display:none" class="tw-mt-8">
                    <h5 class="form-header tw-mb-2"><?php echo _('Log Indices'); ?></h5>
                    <div class="form-subheader"><?php echo _('Select the log indices to migrate.'); ?></div>
                    <div class="form-spacer"></div>
                    <div class="tw-max-h-[600px] tw-overflow-auto tw-mb-6">
                        <table id="available-indices-table" class="ui-table">
                            <thead class="ui-thead">
                                <tr class="ui-tr">
                                    <th class="ui-th tw-w-[18px]"><div class="tw-flex tw-items-center"><input type="checkbox" id="cb-toggle" class="ui-checkbox-group-item"></div></th>
                                    <th class="ui-th"><?php echo _("Index"); ?></th>
                                    <th class="ui-th"><?php echo _("Status"); ?></th>
                                </tr>
                            </thead>
                            <tbody class="ui-tbody">
                            </tbody>
                        </table>
                    </div>
                    <div id="there-are-closed-indices2" class="tw-mb-2 tw-w-full" style="display:none">
                        <label id="closed-indices-messsage2" for="force-index" class="ui-label tw-text-foreground"></label>
                    </div>
                    <div class="ui-checkbox-group">
                        <div class="tw-flex tw-items-center tw-space-x-2">
                            <input type="checkbox" id="force-index" name="force-index" value="1" class="ui-checkbox-group-item">
                            <label for="force-index" class="ui-label tw-text-foreground"><?php echo _('Reprocess selected indices instead of resuming processing.'); ?></label>
                        </div>
                        <div class="tw-flex tw-items-center tw-space-x-2">
                            <input type="checkbox" id="nagios-logserver-metadata" name="nagios-logserver-metadata" value="1" class="ui-checkbox-group-item">
                            <label for="nagios-logserver-metadata" class="ui-label tw-text-foreground"><?php echo _('Migrate Log Server configuration.'); ?></label>
                        </div>
                    </div>
                    <div class="tw-mb-2 tw-mt-6 tw-w-full">
                        <button class="ui-btn ui-btn-default" id="start-migration" disabled><?php echo _("Start Migration of Selected Indices") ?></button>
                    </div>
                </div>
            </tabs-content>
            <tabs-content value="status">
                <div class="tw-w-1/4 tw-pb-2">
                    <div class="tw-mb-2 tw-w-full">
                        <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("Source Log Server Host"); ?></label>
                        <input class="ui-input" id='get-indices-ip' type="text" placeholder="127.0.0.1">
                        <button class="ui-btn ui-btn-default tw-mt-6" id="get-indices"><?php echo _("Get Indices"); ?></button>
                    </div>
                </div>
                <div id="check-index-selection" style="display:none" class="tw-mt-8">
                    <h5 class="form-header tw-mb-2"><?php echo _('Log Indices'); ?></h5>
                    <div class="form-subheader"><?php echo _('View log indices and check their migration status.'); ?></div>
                    <div class="form-spacer"></div>
                    <div class="tw-max-h-[600px] tw-overflow-auto">
                        <table class="ui-table" id="available-indices-status-table">
                            <thead class="ui-thead">
                                <tr class="ui-tr">
                                    <th class="ui-th">Index</th>
                                    <th class="ui-th"># Docs</th>
                                    <th class="ui-th">Primary Size</th>
                                    <th class="ui-th">Status</th>
                                </tr>
                            </thead>
                            <tbody class="ui-tbody">
                            </tbody>
                        </table>
                    </div>
                </div>
            </tabs-content>
        </ui-tabs>
    </div>
</div>

<!-- Migration Status Modal -->
<div id="migration-status" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="migration-status-header" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header" id="migration-status-header"><?php echo _('Migration Status'); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <table class="ui-table">
                    <tbody class="ui-tbody">
                        <tr class="ui-tr">
                            <td class="ui-td"><?php echo _("Migrated Log Entry Count"); ?></td>
                            <td class="ui-td" id="status-migrated-doc-count"></td>
                        </tr>
                        <tr class="ui-tr">
                            <td class="ui-td"><?php echo _("Elapsed Time"); ?></td>
                            <td class="ui-td" id="status-migrated-elapsed-time"></td>
                        </tr>
                        <tr class="ui-tr">
                            <td class="ui-td"><?php echo _("Percent Migrated"); ?></td>
                            <td class="ui-td" id="status-percent-migrated"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>

<div id="migration-check-error" class="modal hide fade" tabindex="-2" role="dialog" aria-labelledby="migration-check-error-header" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header" id="migration-check-header"><?php echo _('Could not connect to source server'); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <div><?php echo _("Do you need to <a target=\"blank\" id=\"migration-source-listen\"> enable ElasticSearch listening on all interfaces?</a>") ?></div>
            </div>
        </div>
    </div>
</div>

<div id="migration-status-error" class="modal hide fade" tabindex="-2" role="dialog" aria-labelledby="migration-status-error-header" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header" id="migration-check-header"><?php echo _('Could not connect to source server'); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
        </div>
    </div>
</div>

<div id="opensearch-config-error" class="modal hide fade" tabindex="-3" role="dialog" aria-labelledby="opensearch-config-error-header" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header" id="opensearch-config-error-header"><?php echo _('OpenSearch needs configuration'); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <div id="configure-opensearch-message"><?php echo _("Nagios Log Server will now reconfigure the backend. You may be asked to log in again.") ?></div>
                <div id="reconfigure-countdown" class="hide"><?php echo _('60 seconds remaining'); ?></div>
                <div id="configure-opensearch-failed" class="hide"><?php echo _("Nagios Log Server could not restart the back end in a timely manner.") ?></div>
                <button class="ui-btn ui-btn-default tw-mt-4" id="configure-opensearch"><?php echo _("Configure OpenSearch"); ?></button>
            </div>
        </div>
    </div>
</div>

<div id="closed-indices" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="closed-indices-header" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header" id="closed-indices-header"><?php echo _('Closed Indices'); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body tw-mb-4">
                <div id="closed-indices-message"></div>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>
