<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">
        <h1 class="form-title"><?php echo _('Unique Hosts'); ?></h1>
        <div class="tw-flex tw-justify-between tw-items-center">
            <p class="form-subtitle"><?php echo _('Showing logs received from hosts in the last 24 hours.'); ?></p>
            <?php if (count($hosts) > 0) { ?>
                <p class="tw-text-lg"><?php echo _('Amount of hosts') . ": <span class='tw-font-semibold'>" . number_format(count($hosts)) . "</span>"; ?></p>
            <?php } ?>
        </div>
        <div class="form-spacer"></div>

            <div class="tw-overflow-x-auto tw-mt-6">
                <table class="ui-table">
                    <thead class="ui-thead">
                        <tr class="ui-tr">
                            <th class="ui-th"><?php echo _("IP Address (Hostname)"); ?></th>
                            <th class="ui-th"><?php echo _("Log Count"); ?></th>
                        </tr>
                    </thead>
                    <tbody class="ui-tbody">
                        <?php
                        $ci =& get_instance();
                        $ci->load->helper('network');
                        foreach ($hosts as $host => $logs) {
                            $hostname = dns_reverse_lookup($host);
                            $display = $host;
                            if (!empty($hostname) && $hostname != $host) {
                                $display = htmlentities($host . " (" . $hostname . ")", ENT_QUOTES, 'UTF-8');
                            }
                            $query = $host;
                        ?>
                        <tr class="ui-tr">
                            <?php
                                $query = urlencode($query);
                                $query = str_replace('%3A', '\\:', $query);
                            ?>
                            <td class="ui-td"><a href="<?php echo site_url("dashboard?searchQuery=host.ip:$query"); ?>" class="tw-text-primary hover:tw-underline"><?php echo $display; ?></a></td>
                            <td class="ui-td"><?php echo number_format($logs); ?></td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>

            <?php if (count($not_sending) > 0) { ?>
            <div class="tw-mt-12">
                <h2 class="form-header tw-mb-4"><?php echo _('Not Sending'); ?></h2>
                <div class="form-subtitle">
                    <p>
                        <?php echo _('This is a list of hosts that Log Server has received logs from in the past. Hosts in this list did not send any logs during the hourly log sending check.'); ?>
                        <span>
                            <?php echo _('Last sending check was') . " <span class='tw-font-semibold'>" . date('r', get_option('known_hosts_last_check')) . "</span>."; ?>
                        </span>
                    </p>
                </div>
                <div class="form-spacer"></div>
                <div class="tw-overflow-x-auto tw-mt-6">
                    <table class="ui-table">
                        <thead class="ui-thead">
                            <tr class="ui-tr">
                                <th class="ui-th"><?php echo _("IP Address (Hostname)"); ?></th>
                                <th class="ui-th">
                                    <div class="tw-flex tw-items-center tw-gap-2">
                                        <?php echo _("Last Sending Check"); ?>
                                        <?php echo question_tooltip(_('This is the time of the last check that returned logs for the host.')); ?>
                                    </div>
                                </th>
                                <th class="ui-th"></th>
                            </tr>
                        </thead>
                        <tbody class="ui-tbody">
                            <?php
                            foreach ($not_sending as $host => $time) {
                                $hostname = dns_reverse_lookup($host);
                                $display = $host;
                                if (!empty($hostname) && $hostname != $host) {
                                    $display = htmlentities($host . " (" . $hostname . ")", ENT_QUOTES, 'UTF-8');
                                }
                                $query = $host;
                                if (strpos($query, ':') !== false) { $query = '"' . $query . '"'; }
                            ?>
                            <tr class="ui-tr">
                                <td class="ui-td"><a href="<?php echo site_url('dashboard?from=1h&searchQuery=host.ip:'.urlencode($query)); ?>" class="tw-text-primary hover:tw-underline"><?php echo $display; ?></a></td>
                                <td class="ui-td"><?php echo date('r', $time); ?></td>
                                <td class="ui-td tw-flex">
                                    <dropdown-menu data-position="bottom-right">
                                        <dropdown-trigger as-child>
                                            <div class="material-symbols-outlined ui-icon-btn">more_horiz</div>
                                        </dropdown-trigger>
                                        <dropdown-content class="ui-dropdown-content">
                                            <dropdown-item class="ui-dropdown-item" onclick="window.location.href='<?php echo site_url('admin/hosts/remove/'.urlencode($host)); ?>'">
                                                <?php echo _("Remove"); ?>
                                            </dropdown-item>
                                        </dropdown-content>
                                    </dropdown-menu>
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php } ?>
    </div>
</div>

<?php echo $footer; ?>