<?php echo $header; ?>

<script type="text/javascript">
$(document).ready(function() {

    $('.rm').click(function() {
        var id = $(this).data('id');

        <?php if (is_demo_mode()) { ?>
        alert('<?php echo _("This function is not available in demo mode."); ?>');
        <?php } else { ?>
        // Confirm remove
        var conf = confirm("<?php echo _('This action will permanently delete the user.'); ?>");

        if (conf == true) {
            $.post(site_url + 'admin/users/delete', { id: id, '<?php echo $csrf['name']; ?>': '<?php echo $csrf['hash']; ?>' }, function(data) {
                if (data.success == 0) {
                    alert(data.errormsg);
                } else {
                    window.location.href = "<?php echo current_url(); ?>";
                }
            }, 'json');
        }
        <?php } ?>
    });

});
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <h1 class="form-title"><?php echo _('User Management');?></h1>
        <div class="form-spacer"></div>
        <div  class="tw-my-6 tw-flex tw-gap-4">
            <a href="<?php echo site_url('admin/users/create'); ?>" class="ui-btn ui-btn-default tw-flex tw-items-center tw-justify-center tw-gap-2"><div class="material-symbols-outlined tw-text-primary-foreground">add</div><span class="tw-text-primary-foreground"><?php echo _('Create User'); ?></span></a>
            <a href="<?php echo site_url('admin/users/import'); ?>" class="ui-btn ui-btn-outlined tw-flex tw-items-center tw-justify-center tw-gap-2"><div class="material-symbols-outlined tw">person_add</div><span><?php echo _('Add Users from LDAP/AD'); ?></span></a>
        </div>
        <table class="ui-table">
            <thead class="ui-thead">
                <tr class="ui-tr">
                    <th class="ui-th"><?php echo _('Username'); ?></th>
                    <th class="ui-th"><?php echo _('Email'); ?></th>
                    <th class="ui-th"><?php echo _('Access Level'); ?></th>
                    <th class="ui-th"><?php echo _('Account Type'); ?></th>
                    <th class="ui-th"><?php echo _('API Access'); ?></th>
                    <th class="ui-th"></th>
                </tr>
            </thead>
            <tbody  class="ui-tbody">
            <?php foreach ($users as $user): ?>
                <tr class="ui-tr">
                    <td class="ui-td">
                        <?php
                        echo html_escape($user['username']);
                        if (!empty($user['name'])) { 
                            echo ' (' . html_escape($user['name']) . ')'; 
                        }
                        ?>
                    </td>
                    <td class="ui-td"><?php echo html_escape($user['email']);?></td>
                    <td class="ui-td">
                        <?php
                        if ($user['auth_type'] == "admin") {
                            echo _("Admin");
                        } else {
                            echo _("User (Limited Access)");
                        }
                        ?>
                    </td>
                    <td class="ui-td">
                        <?php
                        if (!empty($user['auth_settings'])) {
                            $id = $user['auth_settings']['auth_server_id'];
                            if ($user['auth_settings']['type'] == "ad") {
                                $type = _('Active Directory');
                            } else if ($user['auth_settings']['type'] == "ldap") {
                                $type = 'LDAP';
                            }

                            // Find the server they are a part of
                            foreach ($auth_servers as $as) {
                                if ($as['id'] == $id) {
                                    echo $type . ' - ' . $as['name'];
                                    break;
                                }
                            }
                        } else {
                            echo _('Local');
                        }
                        ?>
                    </td>
                    <td class="ui-td"><?php if ($user['apiaccess'] == 1) { echo _("Yes"); } else { echo _("No"); } ?></td>
                    <td class="ui-td tw-text-center">
                        <dropdown-menu data-position="bottom">
                        <dropdown-trigger as-child>
                            <div class="material-symbols-outlined ui-icon-btn">more_horiz</div>
                        </dropdown-trigger>
                        <dropdown-content class="ui-dropdown-content">
                            <a href="<?php echo base_url("admin/users/edit/".$user['id']); ?>">
                                <dropdown-item class="ui-dropdown-item"><?php echo _("Edit") ;?></dropdown-item>
                            </a>
                        <?php if ($user['id'] != $myuserid && $user['id'] != "1") { ?>
                            <a class="rm" data-id="<?php echo $user['id']; ?>">
                                <dropdown-item class="ui-dropdown-item"><?php echo _("Delete"); ?></dropdown-item>
                            </a>
                        <?php } ?>
                        </dropdown-content>
                        </dropdown-menu>
                    </td>
                </tr>
            <?php endforeach;?>
            </tbody>
        </table>

    </div>
</div>

<?php echo $footer; ?>