<?php
require_once(APPPATH . 'views/leftbar_common.php');

$sections = [
    'Alerting' => [
        'header_text'=> _('Alerting'),
        'items' => [
            [
                'url' => site_url('alerts'),
                'icon' => 'notifications',
                'text' => _('Alerts')
            ],
            [
                'url' => site_url('alerts/history'),
                'icon' => 'history',
                'text' => _('Alert History')
            ],
        ]
    ],
    'Alert Settings' => [
        'header_text'=> _('Alert Settings'),
        'items' => [
            [
                'url' => site_url('alerts/templates'),
                'icon' => 'mail',
                'text' => _('Email Templates')
            ],
            [
                'url' => site_url('alerts/nrdp'),
                'icon' => 'storage',
                'text' => _('Nagios / NRDP')
            ],
            [
                'url' => site_url('alerts/snmp'),
                'icon' => 'radar',
                'text' => _('SNMP Trap Receivers')
            ]
        ]
    ]
];

if (show_nagios_reactor()) {
    $sections['Alert Settings'][] = [
        'url' => site_url('alerts/reactor'),
        'icon' => 'account_tree',
        'text' => _('Nagios Reactor')
    ];
}

renderLeftbar($sections, 'alertsLeftbarOpenSections');
?>