<?php echo $header; ?>

<script type="text/javascript">
    function checkForInputs() {
        let allowSubmit = true;

        // Verify we have username input
        if (!$("#username_box").val()) {
            allowSubmit = false;
            $("#username_box").addClass("error");
            $("#username-error-text").removeClass("tw-hidden");
        } else {
            $("#username_box").removeClass("error");
            $("#username-error-text").addClass("tw-hidden");
        }

        // Verify we have password input
        if (!$("#password_box").val()) {
            allowSubmit = false;
            $("#password_box").addClass("error");
            $("#password-error-text").removeClass("tw-hidden");
        } else {
            $("#password_box").removeClass("error");
            $("#password-error-text").addClass("tw-hidden");
        }

        return allowSubmit;
    }
    $(document).ready(function() {

        // Get url hash and send it to the backend...
        // since we need to somehow get the browser to redirect properly
        // to the kibana dashboards when not logged in
        var hash = window.location.hash;
        if (hash != '') {
            $.post(site_url+'auth/set_redirect_hash', { hash: hash });
        }

        // Frame buster
        if (top.location != self.location) {
            top.location = self.location.href;
        }

        $("#header").addClass("tw-hidden");
        localStorage.removeItem('dashboardId');   
       
    });
</script>


<div class="tw-flex tw-items-center tw-justify-center tw-h-[100vh] tw-bg-background">
    <div class="<?php if ($shrink_width) {echo "tw-w-[40px]"; }; ?>">
        <div class="tw-absolute tw-left-8 tw-top-8">
            <img src="<?php echo base_url('media/images/logos/' . $logo); ?>" class="tw-w-12 tw-h-12"></img>
        </div>
        
        <div class="tw-flex tw-flex-col tw-gap-4 tw-w-[25vw]">
            <div class="tw-flex tw-flex-col tw-items-center">
                <div class="tw-text-5xl tw-font-semibold tw-mb-2 tw-text-foreground"><?php echo _("Welcome"); ?></div>
                <div class="form-subtitle"><?php echo _('Sign in to Nagios Log Server'); ?></div>                
            </div>
            <?php echo form_open(htmlentities($url, ENT_COMPAT, 'UTF-8'), array('class' => 'loginForm', 'onSubmit' => 'return checkForInputs()')); ?>
                <?php if ($error) { echo '<div class="alert alert-error tw-fixed tw-w-[25vw] tw-top-[10vh] tw-overflow-hidden tw-text-ellipsis">' . $error . '</div>'; } ?>
                <?php if ($message) { echo '<div class="alert alert-info tw-fixed tw-w-[25vw] tw-top-[10vh] tw-overflow-hidden tw-text-ellipsis"></i>' . $message . '</div>'; } ?>
                <div>
                    <label class="tw-block tw-text-sm tw-font-medium tw-text-foreground"><?php echo _("Username"); ?></label>
                    <input id="username_box" type="text" name="username" class="ui-input tw-text-foreground" value="<?php echo html_escape($username); ?>" placeholder="<?php echo _('Username'); ?>" autofocus>
                    <div id="username-error-text" class="tw-hidden">
                        <span class="tw-text-error tw-text-xs"><?php echo _("Username is required."); ?></span>
                    </div>
                    <div class="tw-flex tw-flex-row tw-mt-4 tw-justify-between">
                        <label class="tw-block tw-text-sm tw-font-medium tw-text-foreground"><?php echo _("Password"); ?></label>
                    </div>
                    <input id="password_box" type="password" name="password" class="ui-input tw-text-foreground" placeholder="••••••••••">
                    <div id="password-error-text" class="tw-hidden">
                        <span class="tw-text-error tw-text-xs"><?php echo _("Password is required."); ?></span>
                    </div>
                    <div class="tw-flex tw-items-center tw-my-4 tw-justify-between">
                        <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="checkbox" id="remember" name="remember" value="1" class="ui-checkbox-group-item">
                        <label for="remember" class="ui-label tw-text-foreground"><?php echo _('Keep me logged in'); ?></label>
                    </div>
                    <a class="tw-text-primary hover:tw-underline" href="<?php echo site_url('forgot_password'); ?>"><?php echo _('Forgot password?'); ?></a>
                </div>
                <button type="submit" class="login ui-btn ui-btn-default tw-w-full" name="loginButton"><?php echo _('Login'); ?></button>                    
            <?php echo form_close(); ?>
        </div>

        <div class="tw-flex tw-items-center tw-justify-evenly tw-mt-8">
            <a href="tel:+16512049102" class="hover:tw-text-foreground active:tw-text-foreground focus:tw-text-foreground">
                <div class="tw-flex tw-items-center tw-gap-2 hover:tw-bg-secondary tw-p-3 tw-rounded-md tw-transition-colors tw-text-[13px]">
                    <i class="material-symbols-outlined tw-text-foreground" aria-hidden="true">call</i>
                    <div class="no-primary tw-hidden 2xl:tw-block"><?php echo _("Phone"); ?></div>
                </div>
            </a>
            <a href="mailto:sales@nagios.com" class="hover:tw-text-foreground active:tw-text-foreground focus:tw-text-foreground">
                <div class="tw-flex tw-items-center tw-gap-2 hover:tw-bg-secondary tw-p-3 tw-rounded-md tw-transition-colors tw-text-[13px]">
                    <i class="material-symbols-outlined tw-text-foreground" aria-hidden="true">mail</i>
                    <div class="no-primary tw-hidden 2xl:tw-block">sales@nagios.com</div>
                </div>
            </a>
            <a href="https://support.nagios.com/" target="_blank" rel="noreferrer" class="hover:tw-text-foreground active:tw-text-foreground focus:tw-text-foreground">
                <div class="tw-flex tw-items-center tw-gap-2 hover:tw-bg-secondary tw-p-3 tw-rounded-md tw-transition-colors tw-text-[13px]">
                    <i class="material-symbols-outlined tw-text-foreground" aria-hidden="true">forum</i>
                    <div class="no-primary tw-hidden 2xl:tw-block"><?php echo _("Support"); ?></div>
                </div>
            </a>
        </div>       
    </div>
</div>

<?php echo $footer; ?>
