<?php echo $header; ?>

<div class="configure-layout">

    <?php echo $leftbar; ?>

    <div class="form-container">
        <h1 class="form-title"><?php echo _("Apply Logstash Configuration"); ?> </h1>
        <?php
        if (!empty($cmd_ids)) {
            // Let's display the actual configurations going on...
        ?>
        <p class="form-subtitle"><?php echo _("The config is currently being applied. This may take a few minutes. Below is a list of all current instances and their status."); ?></p>
        <div class="form-spacer"></div>

        <div class="tw-overflow-auto tw-mb-4 tw-w-full">
            <table class="ui-table tw-table-fixed">
                <tbody class="ui-tbody">
                    <thead class="ui-thead">
                        <tr class="ui-tr">
                            <th class="ui-th tw-w-[10%]"></th>
                            <th class="ui-th tw-w-1/2"><?php echo _("Name"); ?></th>
                            <th class="ui-th tw-w-full"><?php echo _("Message"); ?></th>
                        </tr>
                    </thead>
                <?php
                foreach ($cmd_ids as $cmd) {
                    $hostname = "";
                    $status = _('Starting');
                    if ($cmd['status'] == "running") { $status = _("Running"); }
                    if ($cmd['address'] != $cmd['hostname']) { $hostname = " (".$cmd['hostname'].")"; }
                    echo '
                    <tr class="apply-node ui-tr" id="'.$cmd['cmd_id'].'" data-status="waiting" data-checks="0">
                        <td class="ui-td">
                            <div class="tw-flex tw-justify-center tw-items-center">
                                <span class="loader status-dot tw-bg-muted"></span>
                            </div>
                        </td>
                        <td class="ui-td tw-truncate">
                            <strong class="hostname">'.$cmd['address'].$hostname.'</strong>
                        </td>
                        <td class="ui-td">
                            <div class="tw-flex tw-items-center">
                                <span class="spinner"></span>
                                <span class="status">'.$status.'...</span>
                            </div>
                        </td>
                    </tr>';
                }
                ?>
            </tbody>
        </table>
        </div>

        <div class="tw-flex tw-gap-2">
            <a href="<?php echo site_url('configure'); ?>" class="ui-btn ui-btn-outlined no-primary"><?php echo _("Back"); ?></a>
            <a href="<?php echo site_url('configure/cancel_apply'); ?>" class="ui-btn ui-btn-default no-primary"><?php echo _("Cancel"); ?></a>
        </div>

        <?php
        } else {
            // Display the standard page...
        ?>
        <div class="form-subtitle"><?php echo _("This will verify and apply your configuration on each logstash instance in your cluster."); ?></div>
        <div class="form-spacer"></div>
        <?php if (!user_has_permission('configure', array('all'))) { ?>
            <div class="alert alert-error">
                <div class="alert-description">
                    <div class="material-symbols-outlined alert-icon">error</div>
                    <?php echo _("You do not have permissions to apply configuration."); ?>
                </div>
            </div>
        <?php } else { ?>
            <button <?php if (is_demo_mode()) { echo "disabled"; } ?> id="apply" class="ui-btn ui-btn-default">
                <?php echo _("Apply"); ?>
            </button>
        <?php } } ?>
        </div>
</div>

<!-- Verify apply modal -->
<div id="apply-confirm" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header"><?php echo _("Are You Sure?"); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <p><?php echo _("Are you sure you want to apply the configurations <em><strong>to all instances</strong></em>?"); ?></p>
                <div><?php echo _("All running logstash services will be restarted on each instance. This may take a couple minutes to verify and restart with the new configuration."); ?></div>
            </div>
            <div class="modal-footer">
                <a href="<?php echo site_url('configure/apply_to_instances'); ?>" class="no-primary ui-btn ui-btn-default"><?php echo _("Yes, Apply Now"); ?></a>
                <button class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _("Cancel"); ?></button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {

    $('#apply').click(function(e) {
        $('#apply-confirm').modal({ backdrop: "static" });
    });

    setInterval(check_apply_status, 1000);

});

function verifyHook(commandId) {
    $('#verify-modal').modal({backdrop: 'static'});
    $('#verify-loader').show();
    $('#verify-config-output').hide();
    $('#verify-message').hide();

    $.post("<?php echo site_url('api/system/get_cmd_info'); ?>", { cmd_id: commandId }, function(cmd_info) {

        // Do the actual config verification...
        $.post(site_url+"api/system/verify_config_syntax", { node: cmd_info.node }, function(data) {
            $('#verify-loader').hide();
            if (data.result == "success") {
                $('#verify-message').removeClass('alert-danger').addClass('alert-success').html('<?php echo _("Configuration is OK!"); ?>');
            } else {
                $('#verify-message').removeClass('alert-success').addClass('alert-error').html('<?php echo _("There was an error in the configuration!"); ?>');

                var error = "";
                $.each(data.output, function(k, v) {
                    error += v + "\n";
                });

                $('#verify-config-output').html(error);
                $('#verify-config-output').show();
                $('#verify-message').show();
            }
        }, 'json');
    });

}

// Checks the command to see if it has been ran yet and updates the display
// for when it does finish... if there is an error, like the command never gets ran, it will
// output hints after 180 seconds that there may be something wrong and after 300 seconds
// it outputs that the node may be offline and after 600 seconds it stops checking all together
// The logstash config command can take longer as logstash can take a long time to stop.
function check_apply_status() {

    $('.apply-node').each(function() {
        var status = $(this).data('status');
        var id = $(this).attr('id');
        var block = $(this);
        var checks = $(this).data('checks');
        if ((status == "waiting" || status == "running") && checks < 600) {
            $.post("<?php echo site_url('api/system/get_cmd_info'); ?>", { cmd_id: id }, function(data) {
                checks = checks + 1;
                block.data('checks', checks);
                block.data('status', data.status);
                if (data.status == "warning") {
                    if (checks > 300) {
                        block.find('.loader').css('background-color', 'hsl(var(--warning))');
                        block.find('.status').html("<?php echo _('Timed out waiting for configuration to apply. The instance may be offline, please check and try again. Alternatively ') .
                            '<a onclick=verifyHook(\"' ?>" + id + "<?php echo '\") class=\"verify-config tw-cursor-pointer tw-text-primary hover:tw-text-primary\">' .
                                _('attempt to verify ') .
                            '</a>' . _('the configuration.');
                        ?>");
                        block.find('.spinner').hide();
                    } else if (checks > 180) {
                        block.find('.status').html("<?php echo _('The apply command hasn\'t started yet. The instance may not be online or is unreachable.'); ?>");
                        block.find('.spinner').hide();
                    } else {
                        block.find('.status').html("<?php echo _('Starting'); ?>...");
                    }
                } else if (data.status == "running") {
                    block.find('.status').html("<?php echo _('Running'); ?>...");
                } else if (data.status == "completed") {
                    if (data.last_run_output == "failed") {
                        block.find('.loader').css('background-color', 'hsl(var(--error))');
                        block.find('.status').html("<?php echo _('The configuration could not be verified. ') .
                            '<a onclick=verifyHook(\"' ?>" + id + "<?php echo '\") class=\"verify-config tw-cursor-pointer tw-text-primary hover:tw-text-primary\">' .
                                _('Show configuration errors.') .
                            '</a>';
                        ?>");
                    } else {
                        block.find('.loader').css('background-color', 'hsl(var(--success))');
                        block.find('.status').html("<?php echo _('Completed'); ?>!");
                    }
                    block.find('.spinner').hide();
                }
            }, 'json');
        }
    });

}
</script>

<!-- Verify configuration modal -->
<div id="verify-modal" class="modal hide fade" tabindex="-1" role="dialog">
    <div class="modal-dialog tw-w-1/2" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header" id="myModalLabel"><?php echo _("Configuration Errors"); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <div id="verify-loader" class="tw-flex tw-items-center">
                    <span class="spinner"></span>
                    <?php echo _("Running"); ?>...
                </div>
                <div id="verify-message" class="alert tw-mb-0"></div>
                <pre id="verify-config-output" class="tw-w-full tw-mt-4"></pre>
            </div>
            <div class="modal-footer">
                <button class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _("Close"); ?></button>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>