<?php echo $header; ?>

<div class="configure-layout">

    <?php echo $leftbar; ?>
    
    <div class="form-container">
    <h1 class="form-title"><?php echo _("Config Snapshots"); ?></h1>
    <p class="form-subtitle"><?php echo _("Save your configs for later. Configs for <em>all</em> instances are saved. When a snapshot is restored it will restore <em>all</em> configs on <em>all</em> instances. Snapshots are stored in <strong>/usr/local/nagioslogserver/snapshots</strong>."); ?></p>
    <div class="form-spacer"></div>
    <?php if (!empty($snapshot_success)) { ?>
    <div class="alert alert-success">
        <?php echo $snapshot_success; ?>
        <button type="button" class="close material-symbols-outlined" data-dismiss="alert">close</button>
    </div>
    <?php } ?>

    <?php if (!empty($snapshot_error)) { ?>
    <div class="alert alert-danger">
        <?php echo $snapshot_error; ?>
        <button type="button" class="close material-symbols-outlined" data-dismiss="alert">close</button>
    </div>
    <?php } ?>

    <?php 
    if (user_has_permission('configure', array('all'))) {
        echo form_open('configure/create_snapshot');
    ?>
        <div class="tw-flex tw-flex-row tw-items-center tw-gap-2 tw-w-80 tw-my-6">
            <input type="text" name="snapshot_name" class="ui-input" placeholder="<?php echo _("Snapshot name &amp; description"); ?>">
            <button type="submit" class="ui-btn ui-btn-default"><?php echo _("Create"); ?></button>
        </div>
    <?php
        echo form_close();
    }
    ?>

    <table class="ui-table tw-mb-8">
        <thead class="ui-head">
            <tr class="ui-tr">
                <th class="ui-th"><?php echo _("Name & Description"); ?></th>
                <th class="ui-th"><?php echo _("Filename"); ?></th>
                <th class="ui-th"><?php echo _("Creation Date"); ?></th>
                <th class="ui-th"></th>
            </tr>
        </thead>
        <tbody class="ui-tbody">
            <?php
            if (count($snapshots) > 0) {
            foreach ($snapshots as $snapshot) {
                if (!array_key_exists('filename', $snapshot)) {
                    $snapshot['filename'] = '';
                }
            ?>
            <tr class="ui-tr">
                <td class="ui-td"><?php echo htmlentities($snapshot['name'], ENT_QUOTES, 'UTF-8'); ?></td>
                <td class="ui-td">
                <?php if (!empty($snapshot['filename'])) { ?>
                    <span <?php echo 'id="ss-'.$snapshot['id'].'"'; ?>>
                        <?php echo htmlentities($snapshot['filename'], ENT_QUOTES, 'UTF-8'); ?>
                    </span>
                <?php } else { ?>
                    <div id="ss-<?php echo $snapshot['id']; ?>" class="tw-flex tw-items-center">
                        <span class="spinner"></span>
                        <?php echo _("Creating"); ?>...
                    </div>
                <?php } ?>
                </td>
                <td class="ui-td">
                <?php if (!empty($snapshot['created'])) { ?>
                    <span class="tw-whitespace-nowrap">
                        <?php echo date("r", $snapshot['created']); ?>
                    </span>
                <?php } else { ?>
                    <span <?php echo 'id="ss-time-'.$snapshot['id'].'"'; ?> class="tw-whitespace-nowrap"></span>
                <?php } ?>
                </td>
                <td class="ui-td">
                    <dropdown-menu data-position="bottom">
                        <dropdown-trigger>
                            <div class="material-symbols-outlined ui-icon-btn">more_horiz</div>
                        </dropdown-trigger>
                        <dropdown-content class="ui-dropdown-content">
                            <a class="<?php if (empty($snapshot['filename'])) { ?>hide<?php } ?>" href="<?php echo site_url('configure/download_snapshot/'.$snapshot['filename']); ?>" <?php echo 'id="ss-download-'.$snapshot['id'].'"'; ?>>
                                <dropdown-item class="ui-dropdown-item">
                                    <?php echo _("Download the .tar.gz file"); ?>
                                </dropdown-item>
                            </a>
                        <?php if (user_has_permission('configure', array('all'))) { ?>
                            <a class="restore <?php if (empty($snapshot['filename'])) { ?>hide<?php } ?>" data-name="<?php echo htmlentities($snapshot['name'], ENT_COMPAT, 'UTF-8'); ?>" data-id="<?php echo $snapshot['id']; ?>" class="restore" <?php echo 'id="ss-restore-'.$snapshot['id'].'"'; ?>>
                                <dropdown-item class="ui-dropdown-item">
                                    <?php echo _("Restore instances to this configuration"); ?>
                                </dropdown-item>
                            </a>
                            <a href="<?php echo site_url('configure/delete_snapshot/'.$snapshot['id']); ?>">
                                <dropdown-item class="ui-dropdown-item">
                                    <?php echo _("Remove"); ?>
                                </dropdown-item>
                            </a>
                        <?php } ?>
                        </dropdown-content>
                    </dropdown-menu>
                </td>
            </tr>
            <?php }
            } else { ?>
            <tr class="ui-tr">
                <td class="ui-td" colspan="9"><?php echo _("No snapshots have been created yet."); ?></td>
            </tr>
            <?php } ?>
        </tbody>
    </table>

    <div class="form-title"><?php echo _("Auto-Created Snapshots"); ?></div>
    <div class="form-spacer"></div>
    <table class="ui-table tw-mt-6">
        <thead class="ui-thead">
            <tr class="ui-tr">
                <th class="ui-th"><?php echo _("Name & Description"); ?></th>
                <th class="ui-th"><?php echo _("Filename"); ?></th>
                <th class="ui-th"><?php echo _("Creation Date"); ?></th>
                <th class="ui-th"></th>
            </tr>
        </thead>
        <tbody class="ui-body">
            <?php
            if (count($auto_snapshots) > 0) {
                foreach ($auto_snapshots as $snapshot) {
                    if (!empty($snapshot['filename'])) {
            ?>
            <tr class="ui-tr">
                <td class="ui-td"><?php echo $snapshot['name']; ?></td>
                <td class="ui-td">
                    <span <?php echo 'id="ss-'.$snapshot['id'].'"'; ?>>
                        <?php echo htmlentities($snapshot['filename'], ENT_QUOTES, 'UTF-8'); ?>
                    </span>
                </td>
                <td class="ui-td">
                <?php if (!empty($snapshot['created'])) { ?>
                    <span class="tw-whitespace-nowrap">
                        <?php echo date("r", $snapshot['created']); ?>
                    </span>
                <?php } else { ?>
                    <span <?php echo 'id="ss-time-'.$snapshot['id'].'"'; ?> class="tw-whitespace-nowrap"></span>
                <?php } ?>
                </td>
                <td class="ui-td">
                    <dropdown-menu data-position="bottom">
                        <dropdown-trigger>
                            <div class="material-symbols-outlined ui-icon-btn">more_horiz</div>
                        </dropdown-trigger>
                        <dropdown-content class="ui-dropdown-content">
                            <a class="<?php if (empty($snapshot['filename'])) { ?>hide<?php } ?>" href="<?php echo site_url('configure/download_snapshot/'.$snapshot['filename']); ?>" <?php echo 'id="ss-download-'.$snapshot['id'].'"'; ?>>
                                <dropdown-item class="ui-dropdown-item">
                                    <?php echo _("Download the .tar.gz file"); ?>
                                </dropdown-item>
                            </a>
                        <?php if (user_has_permission('configure', array('all'))) { ?>
                            <a class="restore <?php if (empty($snapshot['filename'])) { ?>hide<?php } ?>" data-name="<?php echo $snapshot['name']; ?>" data-id="<?php echo $snapshot['id']; ?>" class="restore" <?php echo 'id="ss-restore-'.$snapshot['id'].'"'; ?>>
                                <dropdown-item class="ui-dropdown-item">
                                    <?php echo _("Restore instances to this configuration"); ?>
                                </dropdown-item>
                            </a>
                            <a href="<?php echo site_url('configure/archive_auto_snapshot/'.$snapshot['id']); ?>">
                                <dropdown-item class="ui-dropdown-item">
                                    <?php echo _("Archive this snapshot in the regular snapshots section"); ?>
                                </dropdown-item>
                            </a>
                        <?php } ?>
                        </dropdown-content>
                    </dropdown-menu>
                </td>
            </tr>
            <?php
                    }
                }
            } else { ?>
            <t class="ui-tr"r>
                <td class="ui-td" colspan="9"><?php echo _("No automatic snapshots have been created yet. You probably haven't run an apply command."); ?></td>
            </tr>
            <?php } ?>
        </tbody>
    </table>
    </div>
</div>

<!-- Verify restore modal -->
<div id="restore-confirm" class="modal hide fade" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header"><?php echo _("Are You Sure?"); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <p><?php echo _("Are you sure you want to restore to snapshot"); ?> <strong id="restore-snapshot-name"></strong><em><strong><?php echo _(" to all instances?"); ?></strong></em></p>
                <div><?php echo _("All running logstash services will be restarted on each instance. This may take a couple minutes to restore the database and files on all instances. If a instance does not have a snapshot it will NOT be updated."); ?></div>
            </div>
            <div class="modal-footer">
                <a href="<?php echo site_url('configure/restore_snapshot'); ?>" id="restore-link" class="ui-btn ui-btn-default"><?php echo _("Yes, Restore Now"); ?></a>
                <button class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _("Cancel"); ?></button>
            </div>
        </div>
    </div>
</div>

<script>
var UPDATE;
var UPDATE_ID = '<?php echo $cmd_id; ?>';
var SNAPSHOT_ID = '<?php echo $snapshot_id; ?>';

$(document).ready(function() {
    if (UPDATE_ID != '') {
        UPDATE = setInterval(check_if_completed, 1000);
    }

    // Restore a node... just checking if they want to
    $('.restore').click(function() {
        var id = $(this).data('id');
        $('#restore-snapshot-name').html($(this).data('name'));
        $('#restore-link').attr('href', $('#restore-link').attr('href') + "/" + id);
        $('#restore-confirm').modal({backdrop:"static"});
    });

});

function check_if_completed()
{
    $.get('<?php echo site_url("api/system/get_cmd_info"); ?>', { cmd_id: UPDATE_ID }, function(data) {
        if (data.status == "completed") {
            clearInterval(UPDATE);
            $.get('<?php echo site_url("api/system/get_snapshot_info"); ?>', { snapshot_id: SNAPSHOT_ID }, function(data) {
                $('#ss-'+SNAPSHOT_ID).html(data.filename);
                $('#ss-time-'+SNAPSHOT_ID).html(data.created_readable);
                var working_link = '<?php echo site_url('configure/download_snapshot/'); ?>' + data.filename;
                $('#ss-download-'+SNAPSHOT_ID).attr('href', working_link);
                var working_title = '<?php echo _("Download the .tar.gz file"); ?>';
                $('#ss-download-'+SNAPSHOT_ID).attr('title', working_title);
                //$('#ss-download-'+SNAPSHOT_ID).show();
                //$('#ss-restore-'+SNAPSHOT_ID).show();
            });
        }
    }, 'json');
}
</script>

<?php echo $footer; ?>