<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <div class="doc-wrapper">

            <div class="tw-flex tw-items-end">
                <div class="source-logo">
                    <i class="fa fa-xl fa-fw fa-exchange"></i>
                </div>
                <h1><?php echo _('Network Device'); ?></h1>
            </div>
            <div class="form-spacer"></div>

            <h3><?php echo _("Getting Started"); ?></h3>
            <p class="tw-pb-2.5"><?php echo _("You can send your logs from any network device that allows log reporting. Below we have examples of Cisco and Juniper network devices and how to set them up. We also have a brief explanation of how to set up a generic device that is capable of log reporting."); ?></p>

            <h3><?php echo _("Configuration Setup"); ?></h3>
            <p><?php echo _("If the network device can send system logs to an external source, you can send network device logs to the location below."); ?></p>
            <div class="tw-my-2.5 tw-max-w-md">
                <table class="ui-table">
                    <thead class="ui-thead">
                        <tr class="ui-tr">
                            <th class="ui-th"><?php echo _("Log Server IP/Hostname"); ?></th>
                            <th class="ui-th"><?php echo _("TCP/UDP Port"); ?></th>
                        </tr>
                    </thead>
                    <tbody class="ui-tbody">
                        <tr class="ui-tr">
                            <td class="ui-td"><?php echo $hostname; ?></td>
                            <td class="ui-td"><?php echo $port; ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <ui-tabs default-value="generic">
                <tabs-list>
                    <tabs-trigger value="generic"><?php echo _("Generic"); ?></tabs-trigger>
                    <tabs-trigger value="cisco"><?php echo _("Cisco"); ?></tabs-trigger>
                    <tabs-trigger value="juniper"><?php echo _("Juniper"); ?></tabs-trigger>
                </tabs-list>

                <tabs-content value="generic">
                    <h6><?php echo _("Add a Syslog Server"); ?></h6>
                    <p>
                        <?php echo _("Go to the network device's User Interface and log in. Got to the Administration section and find the event logging or system logging section. Devices normally have a configuration field that requires an IP address and port. Fill in the information with the server information above."); ?>
                    </p>
                    <p><?php echo _("Note: Some devices require you to turn on event or system logging before the device will send logs."); ?></p>
                </tabs-content>

                <tabs-content value="cisco">
                    <h6><?php echo _("Add a Syslog Server"); ?></h6>
                    <p><?php echo _("Go to <i>Administration > System Logs > Remote Log Servers</i> and you will see a table of currently configured syslog servers. Click on the add button to create a new <i>Remote Log Server</i> and you should see the second popup below."); ?></p>
                    <div class="tw-my-2.5">
                        <img src="<?php echo base_url('media/images/cisco_syslog.png'); ?>">
                    </div>
                    <p><?php echo _("Fill in the required two fields with the IP/hostname and port given above."); ?></p>
                    <div class="tw-relative tw-my-2.5">
                        <img src="<?php echo base_url('media/images/cisco_syslog_add.png'); ?>">
                        <div class="tw-absolute tw-top-[130px] tw-left-[210px] tw-text-xs tw-text-black"><?php echo $hostname; ?></div>
                        <div class="tw-absolute tw-top-[161px] tw-left-[210px] tw-text-xs tw-text-black"><?php echo $port; ?></div>
                    </div>
                    <p><?php echo _("Once you're done, click apply and you should start seeing logs."); ?></p>
                </tabs-content>

                <tabs-content value="juniper">
                    <p><?php echo _("This section will show you how to set up your syslog configuration on a Juniper network device. Some routers may have a slightly different user interface. If you would like to configure your device from the command line or would like more information, you can take a look at"); ?> <a target="_new" class="hover:tw-text-primary tw-text-primary" href="https://www.juniper.net/documentation/us/en/software/junos/network-mgmt/topics/topic-map/system-logging.html"><?php echo _("Juniper's Overview of System Logging"); ?></a>.</p>
                    <h6><?php echo _("Enable Syslog"); ?></h6>
                    <p><?php echo _("In order to have your device send syslogs, go to <i>Configuration > Report Settings > Syslog</i> and make sure that the <i>Enable syslog messages</i> checkbox is checked."); ?></p>
                    <h6><?php echo _("Add a Syslog Server"); ?></h6>
                    <p><?php echo _("Also inside of the <i>Syslog</i> section you should see a section similar to the one shown below. We select the checkbox to enable syslog messages, set the IP/Hostname and Port. You can select both event log and traffic logs."); ?></p>
                    <div class="tw-relative tw-my-2.5">
                        <img src="<?php echo base_url('media/images/juniper_syslog.png'); ?>">
                        <div class="tw-absolute tw-top-[49px] tw-left-[102px] tw-text-xs tw-text-black"><?php echo $hostname; ?></div>
                        <div class="tw-absolute tw-top-[49px] tw-left-[224px] tw-text-xs tw-text-black"><?php echo $port; ?></div>
                    </div>
                    <p><?php echo _("Once you're done, click apply and you should start receiving logs."); ?></p>
                </tabs-content>
            </ui-tabs>

            <h3><?php echo _("Verify Incoming Logs"); ?></h3>
            <p><?php echo _("Once you have configured the log sender, you should start receiving logs right away. Put in the sender's IP address to see if you are receiving logs from that IP."); ?></p>
            <div class="form-inline">
                <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                    <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("IP Address"); ?></label>
                    <div class="tw-flex tw-w-1/3">
                        <input class="ui-input" name="sender_ip" type="text">
                        <button id="verify" class="ui-btn ui-btn-default tw-ml-3"><?php echo _("Verify"); ?></button>
                        <span id="verify-loading" class="hide"><i class="spinner"></i></span>
                    </div>
                </div>
            </div>
            <div class="verify">
                <div class="well hide verify-logs" id="verify-output"></div>
            </div>

        </div>
    
    </div>
</div>

<?php echo $footer; ?>