<?php
require_once(APPPATH . 'views/leftbar_common.php');

$sections = [
    'Scheduled Reports' => [
        'header_text'=> _('Scheduled Reports'),
        'header_link' => site_url('reports/scheduled'),
        'items' => is_array($scheduled_reports) ? array_map(function($report) {
            return [
                'url' => site_url('reports/view/' . $report["dashboard-id"] . '#/dashboard/report/' . $report['dashboard-id']),
                'text' => $report['name'],
                'icon_class' => 'fa fa-file-o'
            ];
        }, array_filter($scheduled_reports, function($report) {
            return $report['frequency']['which'] !== 'once' && !$report['hide'];
        })) : []
    ],
    'Default Reports' => [
        'header_text'=> _('Default Reports'),
        'header_link' => site_url('reports/report_management'),
        'items' => array_map(function($report) {
            return [
                'url' => site_url("reports/view/" . $report['_id'] . '#/dashboard/report/' . $report['_id']),
                'text' => $report['_source']['title'],
                'icon_class' => 'fa fa-file-o'
            ];
        }, $default_reports)
    ],
    'Saved Reports' => [
        'header_text'=> _('Saved Reports'),
        'header_link' => site_url('reports/report_management'),
        'items' => array_map(function($report) {
            return [
                'url' => site_url("reports/view/" . $report['_id'] . '#/dashboard/report/' . $report['_id']),
                'text' => $report['_source']['title'],
                'icon_class' => 'fa fa-file-o'
            ];
        }, $dashboard_reports)
    ]
];

renderLeftbar($sections, 'reportsLeftbarOpenSections');
?>