<script>
$(document).ready(function () {
    // Get the export button link and send user to it
    $('.btn-export').on('click', function(e) {
        var type = $(this).data('type');
        var formvalues = 'export=' + type + window.location.hash;
        var url = "<?php echo current_url(); ?>?" + formvalues;
        if (e.which == 2) {
            window.open(url);
        } else if (e.which == 1) {
            window.location = url;
        }
    });

    $(window).on('click', function(e) {
        if (!e.target.matches('#download-button')) {
            var menu = $('#download-menu');
            if (menu.is(":visible")) {
                menu.toggle();
            }
        }
    });

    $('#download-button').on('click', function(e) {
        $('#download-menu').toggle();
    });

    let dashboard_id = window.location.hash.split("/")[3];
    $('#sr-input-dashboard-id').val(dashboard_id);

    // Open the report scheduling modal
    $('.btn-report-action').mousedown(function(e) {
        var is_mail = $(this).hasClass('sr-email');
        if (typeof showScheduledReportModal !== 'undefined' && typeof clearScheduledReportModal !== 'undefined') {
            clearScheduledReportModal(is_mail);
            showScheduledReportModal();
        }
    });
});
</script>

<!-- Bar in the upper right, form actions + export -->
<div class="well report-options" style="position:absolute;right:0">
    <div class="reportexportlinks">
        <a data-url="<?php echo site_url('reports/schedule');?>" alt="<?php echo _('Schedule this Report'); ?>" title="" class="btn btn-sm btn-default tt-bind btn-report-action sr-schedule" data-placement="bottom" data-original-title="<?php echo _('Schedule this Report'); ?>"><i class="fa fa-clock-o"></i></a>
        <a data-url="<?php echo site_url('reports/schedule');?>" alt="<?php echo _('E-mail this Report'); ?>" title="" class="btn btn-sm btn-default tt-bind btn-report-action sr-email" data-placement="bottom" data-original-title="<?php echo _('E-mail this Report'); ?>"><i class="fa fa-envelope"></i></a>
        <div class="btn-group">
            <button id="download-button" type="button" class="btn btn-sm btn-default dropdown-toggle" aria-expanded="false">
                <?php echo _('Download'); ?> <i class="fa fa-caret-down r"></i>
            </button>
            <ul id="download-menu" class="dropdown-menu" aria-labelledby="dLabel" style="left: initial; right: 0;">
                <li><a class="btn-export" data-type="pdf" title="<?php echo _('Download as PDF'); ?>"><i class="fa fa-file-pdf-o l"></i><?php echo _('PDF'); ?></a></li>
                <li><a class="btn-export" data-type="jpg" title="<?php echo _('Download as JPG'); ?>"><i class="fa fa-file-image-o l"></i><?php echo _('JPG'); ?></a></li>
            </ul>
        </div>
    </div>
</div>