<?php echo $header; ?>

<div class="tw-flex tw-justify-center tw-items-center tw-min-h-[60vh]">
    <div class="ui-card tw-max-w-md tw-w-full tw-p-0">
        <?php if ($subscription) { ?>
            <h1 class="tw-text-2xl tw-font-bold tw-text-center tw-mb-4"><?php echo _('Nagios Log Server Subscription Expired'); ?></h1>
            <p class="tw-text-center tw-mb-6"><?php echo _('Please enter your new activation key to renew your subscription.'); ?></p>
        <?php } else { ?>
            <h1 class="tw-text-2xl tw-font-bold tw-text-center tw-mb-4"><?php echo _('Trial License Expired!'); ?></h1>
            <p class="tw-text-center tw-mb-6"><?php echo _('Thank you for trying Nagios Log Server. Sadly, your free trial license has expired.'); ?></p>
        <?php } ?>

        <?php if (!empty($error)) { ?>
            <div class="alert alert-error tw-text-center tw-mb-4"><?php echo $error; ?></div>
        <?php } ?>

        <?php echo form_open('', 'class="tw-flex tw-flex-col tw-gap-4"'); ?>
            <input type="text" name="key" class="ui-input tw-w-full" placeholder="<?php echo gettext("License Key"); ?>">
            <button type="submit" value="1" name="set" class="ui-btn ui-btn-default tw-w-full">
                <?php echo _('Set Key'); ?>
            </button>
        <?php echo form_close(); ?>

        <p class="tw-text-center tw-text-sm tw-mt-6 tw-text-gray-600">
            <?php echo _('If you do not have a license key yet, you can purchase one') . ' <a href="https://www.nagios.com/products/nagios-log-server" target="_blank" class="tw-text-primary hover:tw-underline">' . _('from the Nagios website.').'</a>'; ?>
        </p>
    </div>
</div>

<?php echo $footer; ?>