/** @type {import('tailwindcss').Config} */
module.exports = {
  darkMode: 'selector',
  prefix: 'tw-',
  content: [
    '../../../application/views/**/*.php',
    '../../../application/controllers/Dashboard.php',
    '../../../application/helpers/ldap_ad_helper.php'
  ],
  theme: {
    extend: {
      fontFamily: {
        geist: ['Geist'],
        'geist-mono': ['Geist Mono', 'monospace'],
      },
      fontWeight: {
        thin: 100,
        light: 300,
        normal: 400,
        medium: 500,
        semibold: 600, 
        bold: 700,
        extrabold: 800,
        black: 900,
      },
      colors: {
        border: 'hsl(var(--border))',
        input: 'hsl(var(--input))',
        ring: 'hsl(var(--ring))',
        background: 'hsl(var(--background))',
        foreground: 'hsl(var(--foreground))',
        primary: {
          DEFAULT: 'hsl(var(--primary))',
          foreground: 'hsl(var(--primary-foreground))',
        },
        secondary: {
          DEFAULT: 'hsl(var(--secondary))',
          foreground: 'hsl(var(--secondary-foreground))',
        },
        destructive: {
          DEFAULT: 'hsl(var(--destructive))',
          foreground: 'hsl(var(--destructive-foreground))',
        },
        muted: {
          DEFAULT: 'hsl(var(--muted))',
          foreground: 'hsl(var(--muted-foreground))',
          light: 'hsl(var(--text-muted-light))',
        },
        accent: {
          DEFAULT: 'hsl(var(--accent))',
          foreground: 'hsl(var(--accent-foreground))',
        },
        popover: {
          DEFAULT: 'hsl(var(--popover))',
          foreground: 'hsl(var(--popover-foreground))',
        },
        card: {
          DEFAULT: 'hsl(var(--card))',
          foreground: 'hsl(var(--card-foreground))',
        },
        nagiosBlue: 'hsl(var(--nagios-blue))',
        info: {
          DEFAULT: 'hsl(var(--info-msg-text))',
          msg: 'hsl(var(--info-msg-text))',
          border: 'hsl(var(--info-msg-border))',
          background: 'hsl(var(--info-msg-bg))',
          "bg-hover": 'hsl(var(--info-msg-bg-hover))',
        },
        success: {
          DEFAULT: 'hsl(var(--success))',
          msg: 'hsl(var(--success-msg-text))',
          border: 'hsl(var(--success-msg-border))',
          background: 'hsl(var(--success-msg-bg))',
          "bg-hover": 'hsl(var(--success-msg-bg-hover))',
        },
        warning: {
          DEFAULT: 'hsl(var(--warning))',
          msg: 'hsl(var(--warning-msg-text))',
          "msg-hover": 'hsl(var(--warning-msg-text-hover))',
          border: 'hsl(var(--warning-msg-border))',
          background: 'hsl(var(--warning-msg-bg))',
          "bg-hover": 'hsl(var(--warning-msg-bg-hover))',
        },
        error: {
          DEFAULT: 'hsl(var(--error))',
          msg: 'hsl(var(--error-msg-text))',
          "msg-hover": 'hsl(var(--error-msg-text-hover))',
          border: 'hsl(var(--error-msg-border))',
          background: 'hsl(var(--error-msg-bg))',
          "bg-hover": 'hsl(var(--error-msg-bg-hover))',
        },
        unknown: {
          DEFAULT: 'hsl(var(--unknown))',
          msg: 'hsl(var(--unknown-msg-text))',
          "msg-hover": 'hsl(var(--unknown-msg-text-hover))',
          border: 'hsl(var(--unknown-msg-border))',
          background: 'hsl(var(--unknown-msg-bg))',
          "bg-hover": 'hsl(var(--unknown-msg-bg-hover))',
        },
        silver: {
          '50': '#FCFCFC',
          '100': '#f9f9f9',
          '150': '#f0f0f0',
          '200': '#e8e8e8',
          '300': '#e0e0e0',
          '400': '#d9d9d9',
          '500': '#cecece',
          '600': '#bbbbbb',
          '700': '#8d8d8d',
          '800': '#838383',
          '900': '#646464',
          '950': '#4a4a4a',
          '975': '#474747',
          '1000': '#202020',
        },
        storm: {
          1000: '#111111',
          950: '#191919',
          900: '#222222',
          800: '#2A2A2A',
          700: '#313131',
          600: '#3A3A3A',
          500: '#484848',
          400: '#606060',
          300: '#6E6E6E',
          200: '#7B7B7B',
          100: '#838383',
          50: '#EEEEEE',
        }
      },
      borderRadius: {
        lg: 'var(--radius)',
        md: 'calc(var(--radius) - 2px)',
        sm: 'calc(var(--radius) - 4px)',
      },
      minWidth: {
        '80': '20rem',
        '96': '24rem',
        '112': '28rem',
        '128': '32rem',
      },
      borderColor: {
        DEFAULT: 'hsl(var(--border))',
      },
    },
  },
  plugins: [],
};