#!/bin/bash
#
# Bash script for creating Nagios Log Server backups
# Copyright 2014 - Nagios Enterprises LLC
#
# These backups are used to store the main databases for Nagios Log Server including the kibana
# database, log server's internal database, and log server's internal log database
#

INDEXNAMES=( "nagioslogserver_snapshot" "nagioslogserver_scheduled_report" "nagioslogserver_history_alert" \
"nagioslogserver_query" "nagioslogserver_snmp_reactor" "nagioslogserver_alert" "nagioslogserver_node" \
"nagioslogserver_host_list" "nagioslogserver_user" "nagioslogserver_reactor_server" \
"nagioslogserver_log" "nagioslogserver_deleted_alert" "nagioslogserver_email_template" "nagioslogserver_commands" \
"nagioslogserver_dashboards" "nagioslogserver_nrdp_server" "nagioslogserver_migration" "nagioslogserver_reports" \
"nagioslogserver_snmp_receiver" "nagioslogserver_easy_buttons" "nagioslogserver_index_usage" \
"nagioslogserver_cf_option" )
LOGSERVER_DIR="/usr/local/nagioslogserver"
BACKUP_DIR="/store/backups/nagioslogserver"
TIMESTAMP=$(date +%s)
DATE=$(date +%F)
PYTHON=$(which python 2>/dev/null || which python3 2>/dev/null || which python2 2>/dev/null)

# Create mapping files with the index mapping data
echo "Starting Nagios Log Server Backup"
echo "---------------------------------"
set -e
mkdir -p "$BACKUP_DIR/$TIMESTAMP"
chmod 777 "$BACKUP_DIR/$TIMESTAMP"
set +e

# Create a backup of each of the indexes and store them in our temp directory
echo -n "Backing up indexes."
echo ""

# Wait for OpenSearch export jobs to finish...
echo "Waiting for backup. This may take a while."    
echo ""

for index in "${INDEXNAMES[@]}"; do
    echo -n "Backing up $index ..."

    php $LOGSERVER_DIR/scripts/dump_index.php --input "https://localhost:9200/$index" --output "$BACKUP_DIR/$TIMESTAMP/$index" 2>/dev/null    
    echo " Completed."
done

cd "$BACKUP_DIR/$TIMESTAMP"

mkdir -p "$BACKUP_DIR/$TIMESTAMP/snapshots"
tar zcvf "$BACKUP_DIR/$TIMESTAMP/snapshots.tar.gz" $LOGSERVER_DIR/snapshots

# Compress entire directory into a single file
cd $BACKUP_DIR
dirname="nagioslogserver.$DATE.$TIMESTAMP"
mv $TIMESTAMP $dirname
tar czf "$BACKUP_DIR/$dirname.tar.gz" $dirname
chown nagios "$BACKUP_DIR/$dirname.tar.gz"
rm -rf $dirname

echo ""
echo "Backup completed."
