#!/bin/bash

# Requires Node 20.x or higher.

npm install --save-exact --save-dev esbuild postject
npm install elasticdump

cd node_modules/elasticdump
pwd
echo '{ "main": "esdump.mjs", "output": "sea-prep.blob" }' > sea-config.json
patch -p 1 < ../../elasticdump.patch

../.bin/esbuild ./elasticdump --bundle --outfile=esdump.mjs --platform=node

node --experimental-sea-config sea-config.json
cp $(command -v node) out
npx postject out NODE_SEA_BLOB sea-prep.blob \
    --sentinel-fuse NODE_SEA_FUSE_fce680ab2cc467b6e072b8b5df1996b2

cd ../..

mv node_modules/elasticdump/out ../elasticdump

rm -rf node_modules package* 

