<?php defined('BASEPATH') OR exit('No direct script access allowed');


function get_documents_from_index($curl_session, $index, $start = 0, $count = 100, $opensearch=false, $scroll_id='') {
    global $source_url_base;
    $query = ['size' => $count];
    if (!$opensearch) {
        $query['from'] = $start;
    } else {
    }

    $url = "$source_url_base/$index/_search";
    if ($scroll_id == '1234') {
        $url .= "?scroll=10m";
    } else if (strlen($scroll_id) > 0) {
        $query = [];
        $query['scroll'] = '10m';
        $query['scroll_id'] = $scroll_id;
        $url = "$source_url_base/_search/scroll";
    }

    curl_setopt($curl_session, CURLOPT_URL, $url);
    curl_setopt($curl_session, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($curl_session, CURLOPT_POSTFIELDS, json_encode($query));

    return curl_exec($curl_session);
}

function make_jsonl_for_record($index, $record) {
    $id = $record->_id;
    $record_data = $record->_source;

    if (isset($record->_type)) {
        $type = $record->_type;
        if ($index == 'kibana-int') {
            $dest_index = strtolower('nagioslogserver_' . $type . 's');
        } else {
            $dest_index = strtolower($index . '_' . $type);
        }
        $record_data->_type = $type;
    } else {
        $dest_index = $index;
    }

    $data = json_encode($record_data);

    $jsonl = "{\"create\": { \"_index\": \"$dest_index\", \"_id\": \"$id\" } }\n";
    $jsonl .= " $data \n";

    return $jsonl;
}

function do_bulk_insert($session, $jsonl) {
    global $destination_url_base, $opensearch_password;

    curl_setopt($session, CURLOPT_URL, "$destination_url_base/_bulk");
    curl_setopt($session, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($session, CURLOPT_POSTFIELDS, $jsonl);
    curl_setopt($session, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($session, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($session, CURLOPT_HTTPHEADER, array('Content-Type:application/x-ndjson'));
    curl_setopt($session, CURLOPT_USERPWD, 'nagioslogserver:' . $opensearch_password);
    curl_setopt($session, CURLOPT_RETURNTRANSFER, true);

    $response = json_encode( curl_exec($session));

    // TODO: Handle response ->"errors":true case
    //echo "Nagios Log Server Migration Bulk Insert Response: $response";
    //syslog(LOG_INFO, "Nagios Log Server Migration Bulk Insert Response: $response");
}