<?php

$section = $argv[1];
$key = $argv[2];
$value = $argv[3];

$NCPA_CFG = '/usr/local/ncpa/etc/ncpa.cfg';

$allowed_sections = array(
	'api' => 0,
	'nrdp' => 1
);

$allowed_keys = array(
	'community_string' => 0,
	'token' => 1
);

if (!isset($allowed_sections[$section]) || !isset($allowed_keys[$key]) || $allowed_sections[$section] !== $allowed_keys[$key]) {
	echo json_encode(array('status' => 'failed', 'message' => _('NCPA CFG section heading/key pair were not valid')));
    exit(1);
}

$lines = file_get_contents($NCPA_CFG);

$count = 0;
$value = str_replace(array('$', '/'), array('\$', '\/'), $value);
$new_contents = preg_replace('/(\[' . $section . '\][^\[]*\n\h*' . $key . '\h*=\h*)[^\s]*(\s*\n)/s', '${1}' . $value . '${2}', $lines, -1, $count);
$result = array('message' => _('Success!'));
$rc = 0;
if ($count == 0) {
    // Add the token's line between the [api] header and the next square-bracketed header.
    // Doesn't account for comments but let's see if anyone even tries that...
    $new_contents = preg_replace('/(\['.$section.'\][^\[]*\n)/s', '${1}' . "\n" . $key . ' = ' . $value . "\n", $lines, -1, $count);
}
if ($count == 0) {
    $result = array('status' => 'failed', 'message' => _("Could not replace token in ncpa.cfg"));
    $rc = 1;
}

if (file_put_contents($NCPA_CFG, $new_contents) === false) {
    $result = array('status' => 'failed', 'message' => _('Failed to write to file.'));
    $rc = 1;
}

echo json_encode($result);
exit($rc);