#!/bin/bash
#
# Bash script for resetting the 'nagiosadmin' user password
# Copyright 2014 - Nagios Enterprises LLC
#
# Resets the nagiosadmin user password by replacing the hash in the db.
#

newpass=''

# Display how to use
usage () {
    printf "\n"
    printf "Use this script to reset the nagiosadmin password in Nagios Log Server.\n"
    printf "\n"
    printf " -p | --password		The new nagiosadmin password\n"
    printf "\n"
}

if [ -n "$1" ]; then
	case "$1" in
		-h | --help)
			usage
			exit 0
			;;
		-p | --password)
			newpass=$2
			;;
esac
else
	case "$1" in
		*)
			printf "Enter a new password: \n"
			read -s 'newpass'
			;;
	esac
fi

if [ "X$newpass" == 'X' ]; then
    printf "You must enter a password.\n"
    usage
    exit 1
fi

# Verify that OpenSearch is running
if service opensearch status | grep -q 'stopped'; then
    printf "Error: OpenSearch must be running.\n"
    exit 1
fi

# Create a new password hash
passhash=$(printf "$newpass" | openssl sha256 | awk '{printf $2}')

update="{\"doc\":{\"password\":\"$passhash\"}}"

if [ -f /usr/local/nagioslogserver/opensearch/config/opensearch_config.php ]; then
    nlspass=`grep opensearch_password /usr/local/nagioslogserver/opensearch/config/opensearch_config.php | sed "s/.* = '\(.*\)';/\1/"`
else
    nlspass=`grep opensearch_password /var/www/html/nagioslogserver/application/config/config.local.php | sed "s/.* = '\(.*\)';/\1/"`
fi
# Save new password into OpenSearch
curl -u nagioslogserver:$nlspass -H "Content-Type: application/json" --cacert /usr/local/nagioslogserver/opensearch/config/root-ca.pem -XPOST https://localhost:9200/nagioslogserver_user/_update/1 -d "$update" 
curl -u nagioslogserver:$nlspass --cacert /usr/local/nagioslogserver/opensearch/config/root-ca.pem -XPOST https://localhost:9200/nagioslogserver_user/_refresh 

printf "The password has been set for nagiosadmin user.\n"
