#!/bin/bash -e

# Adapted from https://opensearch.org/docs/2.14/install-and-configure/install-opensearch/tar/
cd /usr/local/nagioslogserver/opensearch/config

if [ -z $NODE_NAME ]; then
    NODE_NAME=`hostname --fqdn`
fi

SELF_IP=$(hostname -I | cut -d ' ' -f 1)

# Check root CA existence
if [ ! -e /usr/local/nagioslogserver/opensearch/config/root-ca-key.pem ]; then
    if [ -f /usr/local/nagioslogserver/opensearch/config/opensearch_config.php ]; then
        nlspass=`grep opensearch_password /usr/local/nagioslogserver/opensearch/config/opensearch_config.php | sed "s/.* = '\(.*\)';/\1/"`
    else
        nlspass=`grep opensearch_password /var/www/html/nagioslogserver/application/config/config.local.php | sed "s/.* = '\(.*\)';/\1/"`
    fi
    apiline=`curl -u nagioslogserver:$nlspass --cacert /usr/local/nagioslogserver/opensearch/config/root-ca.pem https://localhost:9200/nagioslogserver_user/_doc/1?pretty=true 2>/dev/null | grep apikey`
    API_TOKEN=`echo $apiline | sed 's/.*" : "//' | sed 's/".*//'`
    node1line=`curl -u nagioslogserver:$nlspass --cacert /usr/local/nagioslogserver/opensearch/config/root-ca.pem https://localhost:9200/nagioslogserver_node/_doc/node1?pretty=true 2>/dev/null | grep address`
    node1=`echo $node1line | sed  's/.*" : "//' | sed 's/".*//'`
    curl http://${node1}/nagioslogserver/api/system/get_opensearch_ca_key?token=${API_TOKEN} -o /usr/local/nagioslogserver/opensearch/config/root-ca-key.pem
    four_oh_four_lines=`grep '404 Page Not Found' /usr/local/nagioslogserver/opensearch/config/root-ca-key.pem | wc -l`
    if [ $four_oh_four_lines -gt 0 ]; then
        rm /usr/local/nagioslogserver/opensearch/config/root-ca-key.pem
        echo 'Failed to obtain the root CA key from the manager node. Did you upgrade it first?'
        exit 1
    fi
    chown nagios:nagios /usr/local/nagioslogserver/opensearch/config/root-ca-key.pem
fi

# Create Node private key
openssl genrsa -out $NODE_NAME-key-temp.pem 2048

# Convert the private key to PKCS#8.
openssl pkcs8 -inform PEM -outform PEM -in $NODE_NAME-key-temp.pem -topk8 -nocrypt -v1 PBE-SHA1-3DES -out $NODE_NAME-key.pem
   
# Create the CSR and replace the arguments passed to -subj so they reflect your specific host.
# The CN should match a DNS A record for the host--do not use the hostname.
openssl req -new -key $NODE_NAME-key.pem -subj "/O=ORG/OU=NAGIOSLOGSERVER/CN=$NODE_NAME" -out $NODE_NAME.csr
   
# Create an extension file that defines a SAN DNS name for the host. This
# should match the DNS A record of the host.
althosts=`ip addr | grep inet | grep -v inet6 | sed 's/.*inet //g' | sed 's/\/.*//g' | grep -v ^127`
ALTNAME=subjectAltName=DNS:localhost
for althost in $althosts
do 
    ALTNAME="$ALTNAME,IP:$althost" 
done
ALTNAME="$ALTNAME,DNS:$NODE_NAME"
echo $ALTNAME > $NODE_NAME.ext

# Sign the cert
openssl x509 -req -in $NODE_NAME.csr -CA root-ca.pem -CAkey root-ca-key.pem -CAcreateserial -sha256 -out $NODE_NAME.pem -days 36500 -extfile $NODE_NAME.ext
# Cleanup
rm *temp.pem *csr *ext

