<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Jobs\RulesetUpdateJob;

class UpdateSuricataRulesets extends Command
{
    protected $signature = 'rulesets:update {frequency}';
    protected $description = 'Manually test the Suricata ruleset update job';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $frequency = $this->argument('frequency');

        $this->info("Dispatching Suricata update job for frequency: {$frequency}");
 
        dispatch(new RulesetUpdateJob($frequency));

        $this->info("Job completed.");
    }
}
