<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use App\Models\NmapScan;
use Illuminate\Contracts\Events\ShouldDispatchAfterCommit;

class NmapScanUpdate implements ShouldDispatchAfterCommit, ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     */
    public function __construct(
        public NmapScan $nmapScan,
        public string $scan_type = "",
        public float $progress_percent = 0.0,
        public string $remaining_time = "",
    ) {}

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array<int, \Illuminate\Broadcasting\Channel>
     */
    public function broadcastOn(): array
    {
        return [
            new PrivateChannel('NNA.Admins'),
        ];
    }

    /**
     * Get the data to broadcast.
     *
     * @return array<string, mixed>
     */
    public function broadcastWith(): array
    {
        return [
            'id' => $this->nmapScan->id,
            'status' => $this->nmapScan->status,
            'started_at' => $this->nmapScan->started_at,
            'finished_at' => $this->nmapScan->finished_at,
            'scan_type' => $this->scan_type,
            'progress_percent' => $this->progress_percent,
            'remaining_time' => $this->remaining_time,
        ];
    }
}
