<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use App\Models\WiresharkScan;

class PacketCaptured implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;
    /**
     * Create a new event instance.
     */
    public function __construct(public WiresharkScan $scan)
    {
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array<int, \Illuminate\Broadcasting\Channel>
     */
    public function broadcastOn(): array
    {
        return [
             new PrivateChannel('NNA.Admins'),
        ];

    }

    public function broadcastWith(): array
    {
        return [
            'id' => $this->scan->id,
            'interface' =>$this->scan->interface,
            'status' => $this->scan->status,
            'started_at' => $this->scan->started_at,
            'finished_at' => $this->scan->finished_at,
            'pid' => $this->scan->pid,

        ];
    }

}
