<?php

namespace App\Jobs;

use App\Models\Check;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\Middleware\WithoutOverlapping;
use Illuminate\Support\Facades\Log;
use Throwable;

class CheckJob implements ShouldQueue
{
    use Queueable;

    public $tries = 3;

    /**
     * Middleware to ensure no other job with the same key runs until this one finishes.
     */
    public function middleware()
    {
        return [new WithoutOverlapping($this->check->id)];
    }

    /**
     * Create a new job instance.
     */
    public function __construct(
        public Check $check,
        public bool $force = false
    ) {}

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $this->check->run_check($this->force);
    }

    /**
     * Handle a job failure.
     */
    public function failed(?Throwable $exception)
    {
        Log::error("Check Job Failed: " . $exception->getMessage());
    }
}
