<?php

namespace App\Jobs;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use App\Events\BackupCreated;
use Illuminate\Support\Facades\Log;

class CreateBackup implements ShouldQueue
{
    use Queueable;

    private $name;
    private $path;

    /**
     * Create a new job instance.
     */
    public function __construct($path)
    {
        $this->name = time();
        $this->path = $path;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        touch($this->path.$this->name.'.tar.gz');       // add script in the stead of this touch
        BackupCreated::dispatch();
        
    }

    /**
     * Handle a job failure.
     */
    public function failed(): void
    {
        Log::warning("Failed to create backup");
    }
}
