<?php

namespace App\Jobs;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use App\Models\SuricataAlert;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;
use Throwable;

class SuricataAlertRolloverJob implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new job instance.
     */
    public function __construct()
    {
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        \Log::info("Rolling over alerts");
        $alerts = SuricataAlert::where('last_hour_count', '>', 0)->get();

        foreach ($alerts as $alert) {
            $alert->rollHourIntoDay();
        }
        \Log::info("Completed rolling over alerts");
    }

    public function failed(?Throwable $exception)
    {
        \Log::error("Failed to rollover suricata alerts: " . ($exception?->getMessage() ?? "No exception passed"));
    }
}
