<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class AlertingAssociations extends Model
{
    public $timestamps = false;

    protected $fillable = [
        'check_id',
        'association_type',
        'association_id',
    ];

    public function check(): BelongsTo
    {
        return $this->belongsTo(Check::class);
    }

    public function association(): MorphTo
    {
        return $this->morphTo('association', 'association_type', 'association_id', 'id');
    }

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'check_id' => 'integer',
            'association_id' => 'integer',
        ];
    }
}
