<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\NmapScan;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Collection;

class Ndiff extends Model
{
     /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'nmap_ndiffs';

    /**
     * The attributes that are mass assignable.
     * 
     * @var list<string>
     */
    protected $fillable = [
        'user_id',
        'started_at',
        'finished_at',
        'scan1_id',
        'scan2_id',
        'title',
        'status',
        'output_filename',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function scan1(): BelongsTo
    {
        return $this->belongsTo(NmapScan::class, 'scan1_id');
    }

    public function scan2(): BelongsTo
    {
        return $this->belongsTo(NmapScan::class, 'scan2_id');
    }

    public function scans(): Collection
    {
        return collect([$this->scan1, $this->scan2]);
    }

    public function scheduledScan(): ?ScheduledScan
    {
        if ($this->scan1 && $this->scan1->scheduledScan &&
            $this->scan2 && $this->scan2->scheduledScan &&
            $this->scan1->scheduled_scan_id === $this->scan2->scheduled_scan_id) {
            return $this->scan1->scheduledScan;
        }
        return null;
    }
}
