<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\ScheduledNmapScan;
use App\Models\NmapScan;
use App\Models\User;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class NmapProfile extends Model
{
    /**
     * The attributes that are mass assignable.
     * 
     * @var list<string>
     */
    protected $fillable = [
        'user_id',
        'name',
        'parameters',
        'description',
        'tags',
        'times_ran',
    ];

    protected $casts = [
        'tags' => 'array',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function scheduledScans(): HasMany
    {
        return $this->hasMany(ScheduledNmapScan::class);
    }

    public function scans(): HasMany
    {
        return $this->hasMany(NmapScan::class, 'nmap_profile_id');
    }
}
