<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\NmapProfile;
use App\Models\NmapScan;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class ScheduledNmapScan extends Model
{
    /**
     * The attributes that are mass assignable.
     * 
     * @var list<string>
     */
    protected $fillable = [
        'user_id',
        'nmap_profile_id',
        'name',
        'parameters',
        'schedule_type',
        'schedule_parameters',
        'last_run_at',
        'times_ran',
        'enabled',
    ];

    protected $casts = [
        'last_run_at' => 'datetime',
        'schedule_parameters' => 'array',
    ];

    public function profile(): BelongsTo
    {
        return $this->belongsTo(NmapProfile::class, 'nmap_profile_id');
    }
    
    public function scans(): HasMany
    {
        return $this->hasMany(NmapScan::class, 'scheduled_nmap_scan_id');
    }
    
    public function latestScan()
    {
        return NmapScan::where('scheduled_nmap_scan_id', $this->id)->latest("id")->first();
    }

    public function previousScan(NmapScan $scan)
    {
        return $this->scans()
                    ->where('id', '!=', $scan->id)
                    ->latest('created_at')
                    ->first();
    }
    
    public function latestNdiff(): ?Ndiff
    {
        return Ndiff::whereIn('scan1_id', $this->scans()->pluck('id'))
                    ->orWhereIn('scan2_id', $this->scans()->pluck('id'))
                    ->latest()
                    ->first();
    }
}
