<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Source extends Model
{
    public $timestamps = false;

    protected $fillable = [
        'name',
        'port',
        'addresses',
        'flowtype',
        'directory',
        'lifetime',
        'abnormal_behavior',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'port' => 'integer',
        ];
    }

    public function sourceGroups()
    {
        return $this->belongsToMany(
            SourceGroup::class,
            'source_group_linker',
            'source_id',            // Foreign key for this model
            'source_group_id'       // Foreign key for related model
        );
    }

    public function getFlowsDirectory()
    {
        return rtrim($this->directory, '/') . '/flows/';
    }
}
