<?php

// app/Models/Alert.php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;

class SuricataAlert extends Model
{

    protected $table = 'suricata_alert';
    
    protected $fillable = [
        'signature_id',
        'signature_name',
        'category',
        'severity',
        'last_day_count',
        'last_hour_count',
        'last_seen',
    ];

    /**
     * Increment last hour count by a given amount.
     */
    public function incrementLastHour(int $count = 1): void
    {
        $this->last_hour_count += $count;
        $this->save();
    }

    /**
     * Add last hour count into today's bucket and reset.
     */
    public function rollHourIntoDay(): void
    {

        $this->last_day_count += $this->last_hour_count;
        $this->last_hour_count = 0;
        $this->save();
    }
}
