<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\Log;
use Illuminate\Notifications\Messages\BroadcastMessage;
use App\Models\NotificationOptions;

class Alert extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct(
        public NotificationOptions $options
    )
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return $this->options->notification_channel;
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        if ($this->options->alert_type === "check" || $this->options->alert_type === "report") {
            return $this->options->mail_message;
        }
        
        return (new MailMessage)
            ->mailer($this->options->mail_config['mailer'])
            ->line('The introduction to the notification.')
            ->action('Notification Action', url('/'))
            ->line('Thank you for using our application!');
    }

    /**
    * Get the broadcastable representation of the notification.
    */
    public function toBroadcast(object $notifiable): BroadcastMessage
    {
        $alert_title = $this->options->alert_title ?? "Test Alert Title";
        $alert_message = $this->options->alert_message ?? "Test Alert Message";

        return new BroadcastMessage([
            'title' => $alert_title,
            'description' => $alert_message,
            'alert_type' => $this->options->alert_type,
        ]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
