<?php

namespace App\Policies;

use App\Models\AuthServer;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class AuthServerPolicy
{
    /**
     * Perform pre-authorization checks.
     */
    public function before(User $user, string $ability): bool|null
    {
        if ($user->is_admin) {
            return true;
        }
    
        return null;
    }

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can update any models.
     */
    public function updateAny(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can delete any models.
     */
    public function deleteAny(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can import users.
     */
    public function importUsers(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can query an auth server.
     */
    public function queryAuthServer(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can validate an auth server.
     */
    public function validate(User $user): bool
    {
        return false;
    }
}
