<?php

namespace App\Policies;

use App\Models\Dashlet;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class DashletPolicy
{
    /**
     * Perform pre-authorization checks.
     */
    public function before(User $user, string $ability): bool|null
    {
        if ($user->is_admin) {
            return true;
        }
    
        return null;
    }
    
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Dashlet $dashlet): bool
    {
        return $user->id === $dashlet->dashboard->user_id;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Dashlet $dashlet): bool
    {
        return $user->id === $dashlet->dashboard->user_id;
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Dashlet $dashlet): bool
    {
        return $user->id === $dashlet->dashboard->user_id;
    }
}
