<?php

namespace App\Policies;

use App\Models\NmapScan;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class NmapScanPolicy
{
    /**
     * Perform pre-authorization checks.
     */
    public function before(User $user, string $ability): bool|null
    {
        if ($user->is_admin) {
            return true;
        }
    
        return null;
    }

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can delete any models.
     */
    public function deleteAny(User $user): bool
    {
        return false;
    }

     /**
     * Determine whether the user can download the model.
     */
    public function downloadAny(User $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can stop any scan.
     */
    public function stopAny(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can get the current version of Nmap installed.
     */
    public function version(User $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can get overview stats of the Nmap integration.
     */
    public function overview(User $user): bool
    {
        return true;
    }
}
