<?php

namespace App\Policies;

use App\Models\SourceGroup;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class SourceGroupPolicy
{
    /**
     * Perform pre-authorization checks.
     */
    public function before(User $user, string $ability): bool|null
    {
        if ($user->is_admin) {
            return true;
        }
    
        return null;
    }

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can update any models.
     */
    public function updateAny(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can delete any models.
     */
    public function deleteAny(User $user): bool
    {
        return false;
    }

     /**
     * Determine whether the user can start any source group.
     */
    public function startAny(User $user): bool
    {
        return false;
    }

     /**
     * Determine whether the user can stop any source group.
     */
    public function stopAny(User $user): bool
    {
        return false;
    }

     /**
     * Determine whether the user can restart any source group.
     */
    public function restartAny(User $user): bool
    {
        return false;
    }
}
