<?php

namespace App\Policies;

use App\Models\SuricataAlert;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class SuricataAlertPolicy
{
    /**
     * Perform pre-authorization checks.
     */
    public function before(User $user, string $ability): bool|null
    {
        if ($user->is_admin) {
            return true;
        }
    
        return null;
    }

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return true;
    }
}
