<?php

namespace App\Policies;

use App\Models\SuricataConfig;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class SuricataConfigPolicy
{
    /**
     * Perform pre-authorization checks.
     */
    public function before(User $user, string $ability): bool|null
    {
        if ($user->is_admin) {
            return true;
        }
    
        return null;
    }

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can update any models.
     */
    public function updateAny(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can delete any models.
     */
    public function deleteAny(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can run whois.
     */
    public function useWhoIs(User $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can run reverse DNS.
     */
    public function useReverseDns(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can import Pcap files to be scanned with Suricata.
     */
    public function importPcap(User $user): bool
    {
        return false;
    }
}
