<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Add new columns
            $table->string('ip_address')->nullable();
            $table->renameColumn('name', 'username');
            $table->integer('created_on')->nullable();
            $table->integer('last_login')->nullable();
            $table->boolean('active')->default(1);
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('company')->nullable();
            $table->string('phone')->nullable();
            $table->boolean('apiaccess')->default(0);
            $table->string('apikey')->nullable();
            $table->string('lang')->default('default');
            $table->string('type')->default('local');
            
            // Optionally rename existing columns if needed
            // $table->renameColumn('name', 'full_name');
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Drop the added columns
            $table->dropColumn([
                'ip_address', 'username',
                'created_on', 'last_login', 'active', 'first_name', 'last_name',
                'company', 'phone', 'apiaccess', 'apikey', 'lang', 'type',
            ]);
            
            // Restore renamed columns if any
            // $table->renameColumn('full_name', 'name');
        });
    }
};