<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cf_options', function (Blueprint $table) {
            $table->id();
            $table->timestamp('created');
            $table->timestamp('modified')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->string('name');
            $table->text('value');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cf_options');
    }
};
