<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dashboards', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->string('name');
            $table->integer('user_id');
        });

        Schema::create('dashlets', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->integer('dashboard_id');
            $table->string('name');
            $table->string('title');
            $table->string('description');
            $table->integer('height');
            $table->integer('width');
            $table->json('options');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('dashboards');
        Schema::dropIfExists('dashlets');
    }
};
