<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('suricata_config', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->string('evelog_name')->default('eve.json');
            $table->string('suricata_log_path')->default('/usr/local/var/log/suricata');
            $table->string('suricata_rules_name')->default('suricata.rules');
            $table->string('suricata_rules_path')->default('/usr/local/var/lib/suricata/rules');
            $table->string('suricata_yaml_path')->default('/usr/local/etc/suricata');
            $table->boolean('rulesets_seeded')->default(false);
            $table->boolean('auto_update_rules')->default(false);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('suricata_config');
    }
};
