<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('auth_servers', function (Blueprint $table) {
            $table->id();
            $table->boolean('active');
            $table->string('name');
            $table->string('host')->nullable();
            $table->string('type');
            $table->string('encryption');
            $table->string('basedn');
            $table->string('suffix')->nullable();
            $table->string('controllers')->nullable();
            $table->integer('port');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('auth_servers');
    }
};
