<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sources', function (Blueprint $table) {
            $table->id();
            $table->integer('port');
            $table->string('addresses')->nullable();
            $table->string('name');
            $table->string('flowtype');
            $table->string('directory');
            $table->string('lifetime');
            $table->tinyInteger('abnormal_behavior')->default(1);

            $table->unique(['name', 'port']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sources');
    }
};
