<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $hasIndex = DB::select("SHOW INDEXES FROM users WHERE Key_name = 'users_email_unique'");
            if ($hasIndex) {
                $table->dropUnique(['email']);
            }
            $table->unique('username');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->unique('email');
            $table->dropUnique(['username']);
        });
    }
};
